/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.listener;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.listener.AbstractStatsCollector;
import org.trimou.engine.listener.EnhancedStatsCollector;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.lambda.InputLiteralLambda;

public class EnhancedStatsCollectorTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
    }

    @Test
    public void testDataCollecting() {
        int sleepConstant = 10;
        final AtomicInteger counter = new AtomicInteger();
        EnhancedStatsCollector collector = new EnhancedStatsCollector();
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addMustacheListener((MustacheListener)collector).build();
        InputLiteralLambda sleeper = new InputLiteralLambda(){
            final Random random = new Random();

            public boolean isReturnValueInterpolated() {
                return false;
            }

            public String invoke(String text) {
                try {
                    int count = counter.incrementAndGet();
                    if (count == 1) {
                        throw new RuntimeException();
                    }
                    Thread.sleep(10 + this.random.nextInt(10));
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException();
                }
                return text;
            }
        };
        Mustache mustache = engine.compileMustache("foo", "{{this}}");
        int loop = 50;
        for (int i = 0; i < loop; ++i) {
            try {
                mustache.render((Object)sleeper);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        AbstractStatsCollector.Stats stats = collector.getStats(mustache);
        Assert.assertNotNull((Object)stats);
        Assert.assertEquals((long)(loop - 1), (long)stats.getFinished());
        Assert.assertEquals((long)1L, (long)stats.getErrors());
        Assert.assertTrue((stats.getMaxTime() < 30L ? 1 : 0) != 0);
        Assert.assertTrue((stats.getMeanTime() > 0L && stats.getMeanTime() <= stats.getMaxTime() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)collector.getStats().size());
        Collection rawData = collector.getRawData(mustache);
        Assert.assertEquals((long)loop, (long)rawData.size());
    }

    @Test
    public void testClearData() {
        EnhancedStatsCollector collector = new EnhancedStatsCollector();
        Mustache mustache = MustacheEngineBuilder.newBuilder().addMustacheListener((MustacheListener)collector).build().compileMustache("bar", "BAR");
        mustache.render(null);
        Assert.assertEquals((long)1L, (long)collector.getStats(mustache).getFinished());
        collector.clearData();
        Assert.assertNull((Object)collector.getStats(mustache));
    }

    @Test
    public void testCustomPredicate() {
        EnhancedStatsCollector collector = new EnhancedStatsCollector(Predicates.alwaysFalse(), TimeUnit.DAYS);
        Mustache mustache = MustacheEngineBuilder.newBuilder().addMustacheListener((MustacheListener)collector).build().compileMustache("qux", "Oops");
        mustache.render(null);
        Assert.assertNull((Object)collector.getStats(mustache));
    }
}

