/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.HelperAwareSegment;
import org.trimou.engine.segment.HelperExecutionHandler;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.SegmentType;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;

public class HelperExecutionHandlerTest {
    @Test
    public void testSplitHelperName() {
        this.assertHelperNameParts("name foo", "name", "foo");
        this.assertHelperNameParts("name  hash1=\"DD-MM-yyyy HH:mm\"", "name", "hash1=\"DD-MM-yyyy HH:mm\"");
        this.assertHelperNameParts("name key='value'", "name", "key='value'");
        this.assertHelperNameParts("name key=''value''", "name", "key=''value''");
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(new Runnable(){

            @Override
            public void run() {
                HelperExecutionHandlerTest.this.assertHelperNameParts("name key=''value'", new String[]{"name", "key=''value'"});
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                HelperExecutionHandlerTest.this.assertHelperNameParts("name key=value'", new String[]{"name", "key=value'"});
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                HelperExecutionHandlerTest.this.assertHelperNameParts("name key='value foo", new String[]{"name", "key='value foo"});
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                HelperExecutionHandlerTest.this.assertHelperNameParts("name key=value' foo", new String[]{"name", "key=value' foo"});
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                HelperExecutionHandlerTest.this.assertHelperNameParts("'name key=value", new String[]{"'name key=value"});
            }
        });
    }

    private void assertHelperNameParts(String name, String ... parts) {
        Assert.assertTrue((String)("Parts: " + Arrays.toString(parts) + " != " + Iterators.toString((Iterator)HelperExecutionHandler.splitHelperName((String)name, (HelperAwareSegment)new DummySegment(name)))), (boolean)Iterators.elementsEqual((Iterator)HelperExecutionHandler.splitHelperName((String)name, (HelperAwareSegment)new DummySegment(name)), (Iterator)Iterators.forArray((Object[])parts)));
    }

    static class DummySegment
    implements HelperAwareSegment {
        private final String text;

        public DummySegment(String text) {
            this.text = text;
        }

        public SegmentType getType() {
            return null;
        }

        public String getText() {
            return null;
        }

        public Origin getOrigin() {
            return null;
        }

        public MustacheTagInfo getTagInfo() {
            return null;
        }

        public String getLiteralBlock() {
            return null;
        }

        public void execute(Appendable appendable, ExecutionContext context) {
        }

        public void fn(Appendable appendable, ExecutionContext context) {
        }

        public String toString() {
            return "SECTION:" + this.text + " [template: foo, line: 15, idx: 20]";
        }
    }
}

