/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.lambda.Lambda;
import org.trimou.lambda.SpecCompliantLambda;

public class LiteralBlockSegmentTest
extends AbstractEngineTest {
    private String textParam;
    private Lambda foo = new SpecCompliantLambda(){

        public String invoke(String text) {
            LiteralBlockSegmentTest.this.textParam = text;
            return text;
        }
    };

    @Override
    @Before
    public void buildEngine() {
        this.textParam = null;
        MapTemplateLocator locator = new MapTemplateLocator((Map)ImmutableMap.of((Object)"partial", (Object)"{{! No content}}", (Object)"super", (Object)"{{$extendMe}}Hello{{/extendMe}}"));
        this.engine = MustacheEngineBuilder.newBuilder().addGlobalData("foo", (Object)this.foo).addTemplateLocator((TemplateLocator)locator).setProperty((ConfigurationKey)EngineConfigurationKey.REMOVE_UNNECESSARY_SEGMENTS, (Object)false).build();
    }

    @Test
    public void testBasicSegments() {
        String template = "{{#foo}}{{! My comment}}|{{bar}}|/n|{{=%% %%=}}|Hello%%/foo%%";
        Assert.assertEquals((Object)"|true|/n||Hello", (Object)this.engine.compileMustache("literal_block_basic", template).render((Object)ImmutableMap.of((Object)"bar", (Object)true)));
        Assert.assertEquals((Object)"{{! My comment}}|{{bar}}|/n|{{=%% %%=}}|Hello", (Object)this.textParam);
    }

    @Test
    public void testSection() {
        String template = "{{#foo}} {{#section}}0{{/section}} {{^inverted}}1{{/inverted}} {{/foo}}";
        Assert.assertEquals((Object)" 0 1 ", (Object)this.engine.compileMustache("literal_block_section", template).render((Object)ImmutableMap.of((Object)"section", (Object)true, (Object)"inverted", (Object)false)));
        Assert.assertEquals((Object)" {{#section}}0{{/section}} {{^inverted}}1{{/inverted}} ", (Object)this.textParam);
    }

    @Test
    public void testPartial() {
        String template = "{{#foo}}|{{>partial}}|{{/foo}}";
        Assert.assertEquals((Object)"||", (Object)this.engine.compileMustache("literal_block_partial", template).render(null));
        Assert.assertEquals((Object)"|{{>partial}}|", (Object)this.textParam);
    }

    @Test
    public void testExtend() {
        String template = "{{#foo}}|{{<super}}{{/super}}|{{/foo}}";
        Assert.assertEquals((Object)"|Hello|", (Object)this.engine.compileMustache("literal_block_partial", template).render(null));
        Assert.assertEquals((Object)"|{{<super}}{{/super}}|", (Object)this.textParam);
    }
}

