/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Hammer;
import org.trimou.Mustache;
import org.trimou.engine.parser.Template;
import org.trimou.lambda.InputProcessingLambda;
import org.trimou.lambda.SpecCompliantLambda;

public class SectionSegmentTest
extends AbstractEngineTest {
    @Test
    public void testBoolean() {
        String templateContents = "{{#Boolean}}-{{/Boolean}}{{#boolean}}-{{/boolean}}!";
        Mustache mustache = this.engine.compileMustache("boolean", templateContents);
        Assert.assertEquals((Object)"--!", (Object)mustache.render((Object)ImmutableMap.of((Object)"boolean", (Object)true, (Object)"Boolean", (Object)Boolean.TRUE, (Object)"true", (Object)"true")));
        Assert.assertEquals((Object)"!", (Object)mustache.render((Object)ImmutableMap.of((Object)"boolean", (Object)false)));
    }

    @Test
    public void testIterable() {
        Mustache mustache = this.engine.compileMustache("iterable", "{{#numbers}}la{{iterIndex}}{{iterHasNext}}|{{/numbers}}");
        Assert.assertEquals((Object)"", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", Collections.emptyList())));
        Assert.assertEquals((Object)"la1true|la2true|la3false|", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3))));
        mustache = this.engine.compileMustache("iterable2", "{{#numbers}}la{{iter.index}}{{iter.hasNext}}|{{/numbers}}");
        Assert.assertEquals((Object)"", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", Collections.emptyList())));
        Assert.assertEquals((Object)"la1true|la2true|la3false|", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", (Object)ImmutableList.of((Object)1, (Object)2, (Object)3))));
    }

    @Test
    public void testArray() {
        Mustache mustache = this.engine.compileMustache("array", "{{#numbers}}la{{iterIndex}}{{iterHasNext}}|{{/numbers}}");
        Assert.assertEquals((Object)"", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", (Object)new Integer[0])));
        Assert.assertEquals((Object)"la1true|la2true|la3false|", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", (Object)new Integer[]{1, 2, 3})));
        mustache = this.engine.compileMustache("array2", "{{#numbers}}la{{iter.index}}{{iter.hasNext}}|{{/numbers}}");
        Assert.assertEquals((Object)"", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", (Object)new Integer[0])));
        Assert.assertEquals((Object)"la1true|la2true|la3false|", (Object)mustache.render((Object)ImmutableMap.of((Object)"numbers", (Object)new Integer[]{1, 2, 3})));
    }

    @Test
    public void testLambdas() {
        SpecCompliantLambda literal = new SpecCompliantLambda(){

            public String invoke(String text) {
                return "prefix_" + text;
            }

            public boolean isReturnValueInterpolated() {
                return false;
            }
        };
        InputProcessingLambda processed = new InputProcessingLambda(){

            public String invoke(String text) {
                return "prefix_" + text;
            }

            public boolean isReturnValueInterpolated() {
                return false;
            }
        };
        String templateContents = "{{#lambda}}{{foo}}{{/lambda}}";
        Mustache mustache = this.engine.compileMustache("lambda", templateContents);
        Assert.assertEquals((Object)"prefix_{{foo}}", (Object)mustache.render((Object)ImmutableMap.of((Object)"foo", (Object)"Mine", (Object)"lambda", (Object)literal)));
        Assert.assertEquals((Object)"prefix_Mine", (Object)mustache.render((Object)ImmutableMap.of((Object)"foo", (Object)"Mine", (Object)"lambda", (Object)processed)));
    }

    @Test
    public void testNestedContext() {
        String templateContents = "Hello {{#test}}{{name}}{{/test}}!";
        Mustache mustache = this.engine.compileMustache("nested", templateContents);
        Assert.assertEquals((Object)"Hello Edgar!", (Object)mustache.render((Object)ImmutableMap.of((Object)"test", (Object)new Hammer())));
        Assert.assertEquals((Object)"Hello !", (Object)mustache.render(Collections.singletonMap("test", null)));
    }

    @Test
    public void testIterFirstAndLast() {
        Mustache mustache = this.engine.compileMustache("iter_first_last", "{{#this}}{{#iterIsFirst}}{{this}}|{{/iterIsFirst}}{{#iterIsLast}}{{this}}|{{/iterIsLast}}{{/this}}");
        Assert.assertEquals((Object)"1|3|", (Object)mustache.render((Object)new String[]{"1", "2", "3"}));
        mustache = this.engine.compileMustache("iter_first_last", "{{#this}}{{#iter.isFirst}}{{this}}|{{/iter.isFirst}}{{#iter.isLast}}{{this}}|{{/iter.isLast}}{{/this}}");
        Assert.assertEquals((Object)"1|3|", (Object)mustache.render((Object)new String[]{"1", "2", "3"}));
    }

    @Test
    public void testSegmentSize() {
        Template template = (Template)this.engine.compileMustache("foo", "{{foo}}bar\nbaz{{#qux}}lala{{/qux}}");
        Assert.assertEquals((long)6L, (long)template.getRootSegment().getSegmentsSize(true));
    }

    @Test
    public void testIterOddAndEven() {
        Mustache mustache = this.engine.compileMustache("iter_odd_even", "{{#this}}{{#iter.isOdd}}ODD{{/iter.isOdd}}{{#iter.isEven}}EVEN{{/iter.isEven}}{{/this}}");
        Assert.assertEquals((Object)"ODDEVENODD", (Object)mustache.render((Object)new String[]{"1", "2", "3"}));
    }
}

