/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.AssertUtil;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.HelpersBuilder;

public class NumberHelpersTest
extends AbstractTest {
    @Test
    public void testIsEven() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addIsEven().build()).build();
        Assert.assertEquals((Object)"even", (Object)engine.compileMustache("isEven_value", "{{#this}}{{isEven iterIndex \"even\"}}{{/this}}").render((Object)new String[]{"1", "2", "3"}));
        Assert.assertEquals((Object)"oddevenodd", (Object)engine.compileMustache("isEven_value_else", "{{#this}}{{isEven iterIndex \"even\" \"odd\"}}{{/this}}").render((Object)new String[]{"1", "2", "3"}));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("isEven_section", "{{#isEven this}}even{{/isEven}}").render((Object)3));
        Assert.assertEquals((Object)"even", (Object)engine.compileMustache("isEven_section", "{{#isEven this}}even{{/isEven}}").render((Object)2));
        AssertUtil.assertCompilationFails(engine, "isEven_fail", "{{isEven}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
    }

    @Test
    public void testIsOdd() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addIsOdd().build()).build();
        Assert.assertEquals((Object)"oddodd", (Object)engine.compileMustache("isOdd_value", "{{#this}}{{isOdd iterIndex \"odd\"}}{{/this}}").render((Object)new String[]{"1", "2", "3"}));
        Assert.assertEquals((Object)"oddevenodd", (Object)engine.compileMustache("isOdd_value", "{{#this}}{{isOdd iterIndex \"odd\" \"even\"}}{{/this}}").render((Object)new String[]{"1", "2", "3"}));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("isOdd_section", "{{#isOdd this}}odd{{/isOdd}}").render((Object)4));
        Assert.assertEquals((Object)"odd", (Object)engine.compileMustache("isOdd_section", "{{#isOdd this}}odd{{/isOdd}}").render((Object)9));
        AssertUtil.assertCompilationFails(engine, "isOdd_fail", "{{isOdd}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
    }
}

