/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.context;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.context.DefaultExecutionContext;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.segment.ExtendSectionSegment;

class DebugExecutionContext
extends DefaultExecutionContext {
    private static final Logger logger = LoggerFactory.getLogger(DebugExecutionContext.class);

    public DebugExecutionContext(Configuration configuration) {
        super(configuration);
    }

    @Override
    public void push(ExecutionContext.TargetStack stack, Object baseObject) {
        super.push(stack, baseObject);
        logger.debug("Push [type: {}, stack: {}]", baseObject.getClass(), (Object)this.contextObjectStack.size());
    }

    @Override
    public Object pop(ExecutionContext.TargetStack stack) {
        Object object = super.pop(stack);
        logger.debug("Pop [type: {}, stack: {}]", object.getClass(), (Object)this.contextObjectStack.size());
        return object;
    }

    @Override
    public void addDefiningSection(String name, ExtendSectionSegment segment) {
        super.addDefiningSection(name, segment);
        logger.debug("Extend section set [name: {}]", (Object)name);
    }

    @Override
    protected Object resolve(Object contextObject, String key, ResolutionContext context) {
        Object value = null;
        for (Resolver resolver : this.configuration.getResolvers()) {
            value = resolver.resolve(contextObject, key, context);
            if (value == null) continue;
            logger.debug("Value found [key: {}, resolver: {}]", (Object)key, resolver.getClass());
            break;
        }
        return value;
    }
}

