/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.List;
import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.AbstractSegment;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.Segments;
import org.trimou.engine.segment.TextSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

@Internal
public class PartialSegment
extends AbstractSegment {
    private final TextSegment indentation;

    public PartialSegment(String text, Origin origin, String indentation) {
        super(text, origin);
        this.indentation = indentation != null ? new TextSegment(indentation, new Origin(origin.getTemplate())) : null;
    }

    @Override
    public SegmentType getType() {
        return SegmentType.PARTIAL;
    }

    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        Template partialTemplate = (Template)this.getEngine().getMustache(this.getText());
        if (partialTemplate == null) {
            throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY, "No partial found for the given key: %s %s", this.getText(), this.getOrigin());
        }
        if (this.indentation == null) {
            partialTemplate.getRootSegment().execute(appendable, context);
        } else {
            context.push(ExecutionContext.TargetStack.TEMPLATE_INVOCATION, partialTemplate);
            this.prependIndentation(appendable, context, partialTemplate);
            context.pop(ExecutionContext.TargetStack.TEMPLATE_INVOCATION);
        }
    }

    @Override
    public String getLiteralBlock() {
        return this.getTagLiteral(MustacheTagType.PARTIAL.getCommand() + this.getText());
    }

    @Override
    protected String getSegmentName() {
        return this.getText();
    }

    private void prependIndentation(Appendable appendable, ExecutionContext context, Template partialTemplate) {
        List<List<Segment>> partialLines = Segments.readSegmentLinesBeforeRendering(partialTemplate.getRootSegment());
        for (List<Segment> line : partialLines) {
            line.add(0, this.indentation);
        }
        for (List<Segment> line : partialLines) {
            for (Segment segment : line) {
                segment.execute(appendable, context);
            }
        }
    }
}

