/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.MustacheTagType;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Flow;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.Options;
import org.trimou.util.Checker;

public class ChooseHelper
extends BasicSectionHelper {
    private static final Logger logger = LoggerFactory.getLogger(ChooseHelper.class);

    @Override
    protected int numberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void execute(Options options) {
        options.push(new Flow(options.peek()));
        options.fn();
        options.pop();
    }

    @Override
    public void validate(HelperDefinition definition) {
        super.validate(definition);
        HashSet<String> validNames = new HashSet<String>(4);
        for (Map.Entry<String, Helper> entry : this.configuration.getHelpers().entrySet()) {
            if (!(entry.getValue() instanceof WhenHelper) && !(entry.getValue() instanceof OtherwiseHelper)) continue;
            validNames.add(entry.getKey());
        }
        for (MustacheTagInfo info : definition.getTagInfo().getChildTags()) {
            if (this.isValid(info, validNames)) continue;
            logger.warn("Invalid content detected {}. This helper should only contain when and otherwise sections. Other types of segments are always rendered!", (Object)info);
        }
    }

    private boolean isValid(MustacheTagInfo info, Set<String> validNames) {
        if (!info.getType().equals((Object)MustacheTagType.SECTION)) {
            return false;
        }
        for (String name : validNames) {
            if (!info.getText().startsWith(name)) continue;
            return true;
        }
        return false;
    }

    public static class OtherwiseHelper
    extends BasicSectionHelper {
        @Override
        protected int numberOfRequiredParameters() {
            return 0;
        }

        @Override
        public void execute(Options options) {
            Object conditionObject = options.peek();
            if (conditionObject instanceof Flow) {
                Flow condition = (Flow)conditionObject;
                if (!condition.isTerminated()) {
                    options.fn();
                    condition.terminate();
                }
            } else {
                throw Flow.newInvalidFlowException(options.getTagInfo());
            }
        }
    }

    public static class WhenHelper
    extends BasicSectionHelper {
        @Override
        public void execute(Options options) {
            Object contextObject = options.peek();
            if (contextObject instanceof Flow) {
                Flow flow = (Flow)contextObject;
                if (!flow.isTerminated() && !Checker.isFalsy(options.getParameters().get(0))) {
                    options.fn();
                    flow.terminate();
                }
            } else {
                throw Flow.newInvalidFlowException(options.getTagInfo());
            }
        }
    }
}

