/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.config;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.listener.AbstractMustacheListener;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.validation.Validateable;

public class ValidateableComponentsTest
extends AbstractTest {
    @Test
    public void testValidateableResolver() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addResolver((Resolver)new TestResolver(10, false)).addResolver((Resolver)new TestResolver(11, true)).build();
        for (Resolver resolver : engine.getConfiguration().getResolvers()) {
            if (!(resolver instanceof TestResolver) || resolver.getPriority() == 11) continue;
            Assert.fail();
        }
    }

    @Test
    public void testValidateableListener() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addMustacheListener((MustacheListener)new TestListener(false)).addMustacheListener((MustacheListener)new TestListener(true)).build();
        Assert.assertEquals((long)1L, (long)engine.getConfiguration().getMustacheListeners().size());
        Assert.assertTrue((boolean)(engine.getConfiguration().getMustacheListeners().get(0) instanceof TestListener));
    }

    private class TestListener
    extends AbstractMustacheListener
    implements Validateable {
        private final boolean isValid;

        public TestListener(boolean isValid) {
            this.isValid = isValid;
        }

        public boolean isValid() {
            return this.isValid;
        }
    }

    private class TestResolver
    extends AbstractResolver
    implements Validateable {
        private final boolean isValid;

        public TestResolver(int priority, boolean isValid) {
            super(priority);
            this.isValid = isValid;
        }

        public Object resolve(Object contextObject, String name, ResolutionContext context) {
            return null;
        }

        public boolean isValid() {
            return this.isValid;
        }
    }
}

