/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.context;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.interpolation.MissingValueHandler;
import org.trimou.engine.interpolation.ThrowingExceptionMissingValueHandler;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.resource.ReleaseCallback;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class ValueWrapperTest
extends AbstractTest {
    @Test
    public void testReleaseCallbackInvoked() {
        final AtomicBoolean callbackInvoked = new AtomicBoolean(false);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addResolver((Resolver)new AbstractResolver(120){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                if ("bar".equals(name)) {
                    context.registerReleaseCallback(new ReleaseCallback(){

                        public void release() {
                            callbackInvoked.set(true);
                        }
                    });
                    return "foo";
                }
                return null;
            }
        }).build();
        Assert.assertEquals((Object)"foo", (Object)engine.compileMustache("release_callback_invoked1", "{{bar}}").render(null));
        Assert.assertTrue((boolean)callbackInvoked.get());
        callbackInvoked.set(false);
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("release_callback_invoked2", "{{bar.qux}}").render(null));
        Assert.assertTrue((boolean)callbackInvoked.get());
    }

    @Test
    public void testReleaseCallbackInvokedEvenIfRenderingFails() {
        AtomicBoolean callbackInvoked;
        block2: {
            callbackInvoked = new AtomicBoolean(false);
            MustacheEngine engine = MustacheEngineBuilder.newBuilder().setMissingValueHandler((MissingValueHandler)new ThrowingExceptionMissingValueHandler()).addResolver((Resolver)new AbstractResolver(120){

                public Object resolve(Object contextObject, String name, ResolutionContext context) {
                    context.registerReleaseCallback(new ReleaseCallback(){

                        public void release() {
                            callbackInvoked.set(true);
                        }
                    });
                    return null;
                }
            }).build();
            try {
                engine.compileMustache("release_callback_invoked_rendering_fails", "{{cannotmatch}}").render(null);
                Assert.fail((String)"Rendering should fail");
            }
            catch (MustacheException e) {
                if (MustacheProblem.RENDER_NO_VALUE.equals((Object)e.getCode())) break block2;
                Assert.fail((String)"Unexpected problem");
            }
        }
        Assert.assertTrue((boolean)callbackInvoked.get());
    }

    @Test
    public void testReleaseCallbackFails() {
        final AtomicBoolean callbackInvoked = new AtomicBoolean(false);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addResolver((Resolver)new AbstractResolver(120){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                context.registerReleaseCallback(new ReleaseCallback(){

                    public void release() {
                        throw new NullPointerException();
                    }
                });
                context.registerReleaseCallback(new ReleaseCallback(){

                    public void release() {
                        callbackInvoked.set(true);
                    }
                });
                return null;
            }
        }).build();
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("release_callback_fails", "{{cannotmatch}}").render(null));
        Assert.assertTrue((boolean)callbackInvoked.get());
    }

    @Test
    public void testGetKey() {
        final AtomicReference key = new AtomicReference();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)new AbstractResolver(1){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                key.set(context.getKey());
                return null;
            }
        }).build().compileMustache("getkey", "{{my.key.foo}}").render(null);
        Assert.assertEquals((Object)"my.key.foo", key.get());
    }

    @Test
    public void testGetKeyPartIndex() {
        final ArrayList indexes = new ArrayList();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)new AbstractResolver(1){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                indexes.add(context.getKeyPartIndex());
                return "OK";
            }
        }).build().compileMustache("getkeypartindex", "{{my.key.foo}}").render(null);
        Assert.assertEquals((long)3L, (long)indexes.size());
        Assert.assertEquals((Object)0, indexes.get(0));
        Assert.assertEquals((Object)1, indexes.get(1));
        Assert.assertEquals((Object)2, indexes.get(2));
    }
}

