/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.MapCustomKeyResolver;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.resolver.ThisResolver;

public class MapCustomKeyResolverTest
extends AbstractTest {
    @Test
    public void testCustomKey() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addResolver((Resolver)new MapCustomKeyResolver(Priorities.rightAfter((int)ThisResolver.THIS_RESOLVER_PRIORITY)){

            protected boolean matches(String name) {
                return NumberUtils.isDigits((String)name);
            }

            protected Object convert(String name) {
                return Integer.valueOf(name);
            }
        }).build();
        HashMap<Integer, String> dataMap = new HashMap<Integer, String>();
        dataMap.put(1, "Hello");
        dataMap.put(2, "there");
        Assert.assertEquals((Object)"Hello there!", (Object)engine.compileMustache("map_custom_key_resolver", "{{#data}}{{1}}{{3}} {{2}}{{/data}}!").render((Object)ImmutableMap.of((Object)"data", dataMap)));
    }

    @Test
    public void testEnumKey() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addResolver((Resolver)new EnumKeyResolver()).build();
        HashMap<EnumKey, String> dataMap = new HashMap<EnumKey, String>();
        dataMap.put(EnumKey.ONE, "Hello");
        dataMap.put(EnumKey.TWO, "there");
        Assert.assertEquals((Object)"Hello there!", (Object)engine.compileMustache("map_enum_key_resolver", "{{#data}}{{ONE}} {{TWO}}{{/data}}!").render((Object)ImmutableMap.of((Object)"data", dataMap)));
    }

    private static class EnumKeyResolver
    extends MapCustomKeyResolver {
        private static List<String> keys = new ArrayList<String>(EnumKey.values().length);

        public EnumKeyResolver() {
            super(Priorities.rightAfter((int)ThisResolver.THIS_RESOLVER_PRIORITY));
        }

        protected boolean matches(String name) {
            return keys.contains(name);
        }

        protected Object convert(String name) {
            return EnumKey.valueOf(name);
        }

        static {
            for (EnumKey key : EnumKey.values()) {
                keys.add(key.toString());
            }
        }
    }

    private static enum EnumKey {
        ONE,
        TWO;

    }
}

