/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.ArchiveType;
import org.trimou.Hammer;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.resolver.ReflectionResolver;
import org.trimou.engine.resolver.Resolver;

public class ReflectionResolverTest
extends AbstractEngineTest {
    @Test
    public void testResolution() {
        ReflectionResolver resolver = new ReflectionResolver();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        Hammer hammer = new Hammer();
        Assert.assertNull((Object)resolver.resolve(null, "whatever", null));
        Assert.assertNotNull((Object)resolver.resolve((Object)hammer, "age", null));
        Assert.assertEquals((Object)10, (Object)resolver.resolve((Object)hammer, "age", null));
        Assert.assertNull((Object)resolver.resolve((Object)hammer, "getAgeForName", null));
    }

    @Test
    public void testInterpolation() {
        ImmutableMap data = ImmutableMap.of((Object)"hammer", (Object)new Hammer(), (Object)"type", ArchiveType.class);
        Assert.assertEquals((Object)"Hello Edgar of age 10, persistent: false and !", (Object)this.engine.compileMustache("reflection_resolver", "Hello {{hammer.name}} of age {{hammer.age}}, persistent: {{hammer.persistent}} and {{hammer.invalidName}}!").render((Object)data));
        Assert.assertEquals((Object)"NAIL|jar", (Object)this.engine.compileMustache("reflection_resolver_fields", "{{hammer.nail}}|{{type.JAR.suffix}}").render((Object)data));
        Assert.assertEquals((Object)"jar,war,ear,", (Object)this.engine.compileMustache("reflection_resolver_static_method", "{{#type.values}}{{this.suffix}},{{/type.values}}").render((Object)data));
    }

    @Test
    public void testMemberCacheInvalidation() {
        ReflectionResolver resolver = new ReflectionResolver();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        Hammer hammer = new Hammer();
        Assert.assertNotNull((Object)resolver.resolve((Object)hammer, "age", null));
        resolver.invalidateMemberCache(null);
        Assert.assertEquals((long)0L, (long)resolver.getMemberCacheSize());
        Assert.assertNotNull((Object)resolver.resolve((Object)hammer, "age", null));
        Assert.assertNotNull((Object)resolver.resolve(ArchiveType.class, "JAR", null));
        resolver.invalidateMemberCache(new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.getName().equals(ArchiveType.class.getName());
            }
        });
        Assert.assertEquals((long)1L, (long)resolver.getMemberCacheSize());
    }

    @Test(expected=IllegalStateException.class)
    public void testMultipleInit() {
        ReflectionResolver resolver = new ReflectionResolver();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        resolver.init(null);
    }
}

