/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Mustache;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.SectionSegment;

public class SegmentImmutabilityTest
extends AbstractEngineTest {
    @Test
    public void testReadonlySegments() {
        Mustache mustache = this.engine.compileMustache("immutable", "{{#section}}|{{/section}}");
        Template template = (Template)mustache;
        try {
            template.getRootSegment().iterator().remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)template.getRootSegment().getSegmentsSize(false));
        Assert.assertEquals((long)2L, (long)template.getRootSegment().getSegmentsSize(true));
        SectionSegment section = (SectionSegment)template.getRootSegment().getSegments().get(0);
        Assert.assertEquals((long)1L, (long)section.getSegmentsSize(false));
        try {
            section.iterator().remove();
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }
}

