/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.context;

import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.context.DebugExecutionContext;
import org.trimou.engine.context.DefaultExecutionContext;
import org.trimou.engine.context.ExecutionContext;

@Internal
public class ExecutionContextBuilder {
    private final MustacheEngine engine;
    private Object data;

    public ExecutionContextBuilder(MustacheEngine engine) {
        this.engine = engine;
    }

    public ExecutionContextBuilder withData(Object data) {
        this.data = data;
        return this;
    }

    @Deprecated
    public ExecutionContext build(boolean debugMode) {
        return ExecutionContextBuilder.build(this.engine, this.data, debugMode);
    }

    public static ExecutionContext build(MustacheEngine engine, Object data, boolean debugMode) {
        DefaultExecutionContext context = null;
        context = debugMode ? new DebugExecutionContext(engine.getConfiguration()) : new DefaultExecutionContext(engine.getConfiguration());
        if (engine.getConfiguration().getGlobalData() != null) {
            context.push(ExecutionContext.TargetStack.CONTEXT, engine.getConfiguration().getGlobalData());
        }
        if (data != null) {
            context.push(ExecutionContext.TargetStack.CONTEXT, data);
        }
        return context;
    }
}

