/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.FieldWrapper;
import org.trimou.engine.resolver.MemberKey;
import org.trimou.engine.resolver.MemberWrapper;
import org.trimou.engine.resolver.MethodWrapper;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Reflections;

public class ReflectionResolver
extends AbstractResolver
implements RemovalListener<MemberKey, Optional<MemberWrapper>> {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionResolver.class);
    public static final int REFLECTION_RESOLVER_PRIORITY = Priorities.rightBefore(10);
    public static final String COMPUTING_CACHE_CONSUMER_ID = ReflectionResolver.class.getName();
    public static final ConfigurationKey MEMBER_CACHE_MAX_SIZE_KEY = new SimpleConfigurationKey(ReflectionResolver.class.getName() + ".memberCacheMaxSize", 10000L);
    private ComputingCache<MemberKey, Optional<MemberWrapper>> memberCache;

    public ReflectionResolver() {
        this(REFLECTION_RESOLVER_PRIORITY);
    }

    public ReflectionResolver(int priority) {
        super(priority);
    }

    @Override
    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (contextObject == null) {
            return null;
        }
        MemberKey key = MemberKey.newInstance(contextObject, name);
        MemberWrapper wrapper = this.memberCache != null ? (MemberWrapper)this.memberCache.get(key).orNull() : (MemberWrapper)ReflectionResolver.findWrapper(key).orNull();
        if (wrapper == null) {
            return null;
        }
        try {
            return wrapper.getValue(contextObject);
        }
        catch (Exception e) {
            throw new MustacheException(MustacheProblem.RENDER_REFLECT_INVOCATION_ERROR, (Throwable)e);
        }
    }

    @Override
    public void init() {
        long memberCacheMaxSize = this.configuration.getLongPropertyValue(MEMBER_CACHE_MAX_SIZE_KEY);
        logger.info("Initialized [memberCacheMaxSize: {}]", (Object)memberCacheMaxSize);
        if (memberCacheMaxSize > 0L) {
            this.memberCache = this.configuration.getComputingCacheFactory().create(COMPUTING_CACHE_CONSUMER_ID, new MemberComputingFunction(), null, memberCacheMaxSize, null);
        }
    }

    @Override
    public Set<ConfigurationKey> getConfigurationKeys() {
        return Collections.singleton(MEMBER_CACHE_MAX_SIZE_KEY);
    }

    public void onRemoval(RemovalNotification<MemberKey, Optional<MemberWrapper>> notification) {
    }

    public void invalidateMemberCache(final Predicate<Class<?>> predicate) {
        if (this.memberCache == null) {
            return;
        }
        if (predicate == null) {
            this.memberCache.clear();
        } else {
            this.memberCache.invalidate(new ComputingCache.KeyPredicate<MemberKey>(){

                @Override
                public boolean apply(MemberKey key) {
                    return predicate.apply(key.getClazz());
                }
            });
        }
    }

    long getMemberCacheSize() {
        return this.memberCache != null ? this.memberCache.size() : 0L;
    }

    private static Optional<MemberWrapper> findWrapper(MemberKey key) {
        Method foundMethod = Reflections.findMethod(key.getClazz(), key.getName());
        if (foundMethod != null) {
            return Optional.of((Object)new MethodWrapper(foundMethod));
        }
        Field foundField = Reflections.findField(key.getClazz(), key.getName());
        if (foundField != null) {
            return Optional.of((Object)new FieldWrapper(foundField));
        }
        return Optional.absent();
    }

    private static class MemberComputingFunction
    implements ComputingCache.Function<MemberKey, Optional<MemberWrapper>> {
        private MemberComputingFunction() {
        }

        @Override
        public Optional<MemberWrapper> compute(MemberKey key) {
            return ReflectionResolver.findWrapper(key);
        }
    }
}

