/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.ContainerSegment;
import org.trimou.engine.segment.HelperAwareSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.Options;
import org.trimou.util.Checker;

class HelperExecutionHandler {
    private final Helper helper;
    private final OptionsBuilder optionsBuilder;

    private HelperExecutionHandler(Helper helper, OptionsBuilder optionsBuilder) {
        this.helper = helper;
        this.optionsBuilder = optionsBuilder;
    }

    static HelperExecutionHandler from(String name, MustacheEngine engine, HelperAwareSegment segment) {
        Iterator<String> parts = HelperExecutionHandler.splitHelperName(name, segment);
        Helper helper = engine.getConfiguration().getHelpers().get(parts.next());
        if (helper == null) {
            return null;
        }
        ImmutableList.Builder params = ImmutableList.builder();
        ImmutableMap.Builder hash = ImmutableMap.builder();
        while (parts.hasNext()) {
            String paramOrHash = parts.next();
            if (paramOrHash.contains("=")) {
                hash.put((Object)HelperExecutionHandler.getKey(paramOrHash), HelperExecutionHandler.getLiteralOrPlaceholder(HelperExecutionHandler.getValue(paramOrHash), segment));
                continue;
            }
            params.add(HelperExecutionHandler.getLiteralOrPlaceholder(paramOrHash, segment));
        }
        OptionsBuilder optionsBuilder = new OptionsBuilder((List)params.build(), (Map)hash.build(), segment, engine);
        helper.validate(optionsBuilder);
        return new HelperExecutionHandler(helper, optionsBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(Appendable appendable, ExecutionContext executionContext) {
        DefaultOptions options = this.optionsBuilder.build(appendable, executionContext);
        try {
            this.helper.execute(options);
        }
        finally {
            options.release();
        }
    }

    private static Object getLiteralOrPlaceholder(String value, HelperAwareSegment segment) {
        if (HelperExecutionHandler.isStringLiteralSeparator(value.charAt(0))) {
            return value.substring(1, value.length() - 1);
        }
        return new DefaultValuePlaceholder(value);
    }

    static Iterator<String> splitHelperName(String name, HelperAwareSegment segment) {
        boolean stringLiteral = false;
        boolean space = false;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ' ') {
                if (space) continue;
                if (!stringLiteral) {
                    parts.add(buffer.toString());
                    buffer = new StringBuilder();
                    space = true;
                    continue;
                }
                buffer.append(name.charAt(i));
                continue;
            }
            if (HelperExecutionHandler.isStringLiteralSeparator(name.charAt(i))) {
                stringLiteral = !stringLiteral;
            }
            space = false;
            buffer.append(name.charAt(i));
        }
        if (buffer.length() > 0) {
            if (stringLiteral) {
                throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, "Unterminated string literal: %s", segment.toString());
            }
            parts.add(buffer.toString());
        }
        return parts.iterator();
    }

    private static boolean isStringLiteralSeparator(char character) {
        return character == '\"' || character == '\'';
    }

    private static String getKey(String part) {
        return part.substring(0, part.indexOf("="));
    }

    private static String getValue(String part) {
        return part.substring(part.indexOf("=") + 1, part.length());
    }

    private static class DefaultValuePlaceholder
    implements HelperDefinition.ValuePlaceholder {
        private final String name;

        public DefaultValuePlaceholder(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class DefaultOptions
    implements Options {
        private static final Logger logger = LoggerFactory.getLogger(DefaultOptions.class);
        private final MustacheEngine engine;
        private final List<ValueWrapper> valueWrappers;
        private int pushed = 0;
        private final ExecutionContext executionContext;
        private final HelperAwareSegment segment;
        private final List<Object> parameters;
        private final Map<String, Object> hash;
        private final Appendable appendable;

        public DefaultOptions(Appendable appendable, ExecutionContext executionContext, HelperAwareSegment segment, List<Object> parameters, Map<String, Object> hash, List<ValueWrapper> valueWrappers, MustacheEngine engine) {
            this.appendable = appendable;
            this.executionContext = executionContext;
            this.segment = segment;
            this.parameters = parameters;
            this.hash = hash;
            this.valueWrappers = valueWrappers;
            this.engine = engine;
        }

        @Override
        public void append(CharSequence sequence) {
            try {
                this.appendable.append(sequence);
            }
            catch (IOException e) {
                throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
            }
        }

        @Override
        public void fn() {
            this.segment.fn(this.appendable, this.executionContext);
        }

        @Override
        public void partial(String templateId) {
            Checker.checkArgumentNotEmpty(templateId);
            Template partialTemplate = (Template)this.engine.getMustache(templateId);
            if (partialTemplate == null) {
                throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY, "No partial found for the given key: %s %s", templateId, this.segment.getOrigin());
            }
            partialTemplate.getRootSegment().execute(this.appendable, this.executionContext);
        }

        @Override
        public String source(String templateId) {
            Checker.checkArgumentNotEmpty(templateId);
            String mustacheSource = this.engine.getMustacheSource(templateId);
            if (mustacheSource == null) {
                throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY, "No mustache template found for the given key: %s %s", templateId, this.segment.getOrigin());
            }
            return mustacheSource;
        }

        @Override
        public List<Object> getParameters() {
            return this.parameters;
        }

        @Override
        public Map<String, Object> getHash() {
            return this.hash;
        }

        @Override
        public void push(Object contextObject) {
            ++this.pushed;
            this.executionContext.push(ExecutionContext.TargetStack.CONTEXT, contextObject);
        }

        @Override
        public Object pop() {
            if (this.pushed > 0) {
                --this.pushed;
                return this.executionContext.pop(ExecutionContext.TargetStack.CONTEXT);
            }
            throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_POP_OPERATION);
        }

        @Override
        public Object peek() {
            return this.executionContext.peek(ExecutionContext.TargetStack.CONTEXT);
        }

        @Override
        public MustacheTagInfo getTagInfo() {
            return this.segment.getTagInfo();
        }

        @Override
        public Appendable getAppendable() {
            return this.appendable;
        }

        @Override
        public void fn(Appendable appendable) {
            this.segment.fn(appendable, this.executionContext);
        }

        @Override
        public String getContentLiteralBlock() {
            if (this.segment instanceof ContainerSegment) {
                return ((ContainerSegment)((Object)this.segment)).getContentLiteralBlock();
            }
            return "";
        }

        void release() {
            int wrappersSize = this.valueWrappers.size();
            if (wrappersSize == 1) {
                this.valueWrappers.get(0).release();
            } else if (wrappersSize > 1) {
                for (ValueWrapper wrapper : this.valueWrappers) {
                    wrapper.release();
                }
            }
            if (this.pushed > 0) {
                for (int i = 0; i < this.pushed; ++i) {
                    this.executionContext.pop(ExecutionContext.TargetStack.CONTEXT);
                }
                logger.warn("Cleaned up {} objects pushed on the context stack [helperName: {}, template: {}]", new Object[]{this.pushed, HelperExecutionHandler.splitHelperName(this.getTagInfo().getText(), this.segment).next(), this.getTagInfo().getTemplateName()});
            }
        }
    }

    private static class OptionsBuilder
    implements HelperDefinition {
        private final List<Object> parameters;
        private final Map<String, Object> hash;
        private final HelperAwareSegment segment;
        private final MustacheEngine engine;
        private final boolean isParamValuePlaceholderFound;
        private final boolean isHashValuePlaceholderFound;

        private OptionsBuilder(List<Object> parameters, Map<String, Object> hash, HelperAwareSegment segment, MustacheEngine engine) {
            this.parameters = parameters;
            this.hash = hash;
            this.segment = segment;
            this.engine = engine;
            this.isParamValuePlaceholderFound = this.initParamValuePlaceholderFound(parameters);
            this.isHashValuePlaceholderFound = this.initHashValuePlaceholderFound(hash);
        }

        @Override
        public MustacheTagInfo getTagInfo() {
            return this.segment.getTagInfo();
        }

        @Override
        public List<Object> getParameters() {
            return this.parameters;
        }

        @Override
        public Map<String, Object> getHash() {
            return this.hash;
        }

        @Override
        public String getContentLiteralBlock() {
            if (this.segment instanceof ContainerSegment) {
                return ((ContainerSegment)((Object)this.segment)).getContentLiteralBlock();
            }
            return "";
        }

        public DefaultOptions build(Appendable appendable, ExecutionContext executionContext) {
            Map<String, Object> finalHash;
            List<Object> finalParams;
            int size;
            ImmutableList.Builder valueWrappers = ImmutableList.builder();
            if (this.isParamValuePlaceholderFound) {
                size = this.parameters.size();
                switch (size) {
                    case 1: {
                        finalParams = Collections.singletonList(this.resolveValue(this.parameters.get(0), (ImmutableList.Builder<ValueWrapper>)valueWrappers, executionContext));
                        break;
                    }
                    default: {
                        finalParams = new ArrayList<Object>(size);
                        for (Object param : this.parameters) {
                            finalParams.add(this.resolveValue(param, (ImmutableList.Builder<ValueWrapper>)valueWrappers, executionContext));
                        }
                        finalParams = Collections.unmodifiableList(finalParams);
                        break;
                    }
                }
            } else {
                finalParams = this.parameters;
            }
            if (this.isHashValuePlaceholderFound) {
                size = this.hash.size();
                switch (size) {
                    case 1: {
                        Map.Entry<String, Object> singleEntry = this.hash.entrySet().iterator().next();
                        finalHash = Collections.singletonMap(singleEntry.getKey(), this.resolveValue(singleEntry.getValue(), (ImmutableList.Builder<ValueWrapper>)valueWrappers, executionContext));
                        break;
                    }
                    default: {
                        finalHash = new HashMap<String, Object>();
                        for (Map.Entry<String, Object> entry : this.hash.entrySet()) {
                            finalHash.put(entry.getKey(), this.resolveValue(entry.getValue(), (ImmutableList.Builder<ValueWrapper>)valueWrappers, executionContext));
                        }
                        finalHash = Collections.unmodifiableMap(finalHash);
                        break;
                    }
                }
            } else {
                finalHash = this.hash;
            }
            return new DefaultOptions(appendable, executionContext, this.segment, finalParams, finalHash, (List<ValueWrapper>)valueWrappers.build(), this.engine);
        }

        private Object resolveValue(Object value, ImmutableList.Builder<ValueWrapper> valueWrappers, ExecutionContext executionContext) {
            if (value instanceof HelperDefinition.ValuePlaceholder) {
                ValueWrapper wrapper = executionContext.getValue(((HelperDefinition.ValuePlaceholder)value).getName());
                valueWrappers.add((Object)wrapper);
                return wrapper.get();
            }
            return value;
        }

        private boolean initParamValuePlaceholderFound(List<Object> parameters) {
            if (parameters.isEmpty()) {
                return false;
            }
            for (Object param : parameters) {
                if (!(param instanceof HelperDefinition.ValuePlaceholder)) continue;
                return true;
            }
            return false;
        }

        private boolean initHashValuePlaceholderFound(Map<String, Object> hash) {
            if (hash.isEmpty()) {
                return false;
            }
            for (Map.Entry<String, Object> entry : hash.entrySet()) {
                if (!(entry.getValue() instanceof HelperDefinition.ValuePlaceholder)) continue;
                return true;
            }
            return false;
        }
    }
}

