/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import org.trimou.annotations.Internal;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.AbstractSectionSegment;
import org.trimou.engine.segment.HelperAwareSegment;
import org.trimou.engine.segment.HelperExecutionHandler;
import org.trimou.engine.segment.IterationMeta;
import org.trimou.engine.segment.Lambdas;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.lambda.Lambda;

@Internal
public class SectionSegment
extends AbstractSectionSegment
implements HelperAwareSegment {
    private final HelperExecutionHandler helperHandler;

    public SectionSegment(String text, Origin origin, List<Segment> segments) {
        super(text, origin, segments);
        this.helperHandler = this.isHandlebarsSupportEnabled() ? HelperExecutionHandler.from(text, this.getEngine(), this) : null;
    }

    @Override
    public SegmentType getType() {
        return SegmentType.SECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        if (this.helperHandler != null) {
            this.helperHandler.execute(appendable, context);
        } else {
            ValueWrapper value = context.getValue(this.getText());
            try {
                if (value.isNull()) {
                    return;
                }
                this.processValue(appendable, context, value.get());
            }
            finally {
                value.release();
            }
        }
    }

    @Override
    public void fn(Appendable appendable, ExecutionContext context) {
        super.execute(appendable, context);
    }

    private void processValue(Appendable appendable, ExecutionContext context, Object value) {
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                super.execute(appendable, context);
            }
        } else if (value instanceof Iterable) {
            this.processIterable(appendable, context, value);
        } else if (value.getClass().isArray()) {
            this.processArray(appendable, context, value);
        } else if (value instanceof Lambda) {
            this.processLambda(appendable, context, value);
        } else {
            context.push(ExecutionContext.TargetStack.CONTEXT, value);
            super.execute(appendable, context);
            context.pop(ExecutionContext.TargetStack.CONTEXT);
        }
    }

    private void processIterable(Appendable appendable, ExecutionContext context, Object iterable) {
        Iterator iterator = ((Iterable)iterable).iterator();
        if (!iterator.hasNext()) {
            return;
        }
        IterationMeta meta = new IterationMeta(this.getEngineConfiguration().getStringPropertyValue(EngineConfigurationKey.ITERATION_METADATA_ALIAS), iterator);
        context.push(ExecutionContext.TargetStack.CONTEXT, meta);
        while (iterator.hasNext()) {
            this.processIteration(appendable, context, iterator.next(), meta);
        }
        context.pop(ExecutionContext.TargetStack.CONTEXT);
    }

    private void processArray(Appendable appendable, ExecutionContext context, Object array) {
        int length = Array.getLength(array);
        if (length < 1) {
            return;
        }
        IterationMeta meta = new IterationMeta(this.getEngineConfiguration().getStringPropertyValue(EngineConfigurationKey.ITERATION_METADATA_ALIAS), length);
        context.push(ExecutionContext.TargetStack.CONTEXT, meta);
        for (int i = 0; i < length; ++i) {
            this.processIteration(appendable, context, Array.get(array, i), meta);
        }
        context.pop(ExecutionContext.TargetStack.CONTEXT);
    }

    private void processIteration(Appendable appendable, ExecutionContext context, Object value, IterationMeta meta) {
        context.push(ExecutionContext.TargetStack.CONTEXT, value);
        super.execute(appendable, context);
        context.pop(ExecutionContext.TargetStack.CONTEXT);
        meta.nextIteration();
    }

    private void processLambda(Appendable appendable, ExecutionContext context, Object value) {
        String input;
        Lambda lambda = (Lambda)value;
        switch (lambda.getInputType()) {
            case LITERAL: {
                input = this.getContentLiteralBlock();
                break;
            }
            case PROCESSED: {
                StringBuilder processed = new StringBuilder();
                super.execute(processed, context);
                input = processed.toString();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported lambda input type");
            }
        }
        String returnValue = lambda.invoke(input);
        if (lambda.isReturnValueInterpolated()) {
            Template temp = (Template)this.getEngine().compileMustache(Lambdas.constructLambdaOneoffTemplateName(this), returnValue);
            temp.getRootSegment().execute(appendable, context);
        } else {
            this.append(appendable, returnValue);
        }
    }
}

