/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.config;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.ReflectionResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class ConfigPropertyValueConversionTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
    }

    @Test
    public void testDefaultConversion() {
        this.testValue((ConfigurationKey)EngineConfigurationKey.TEMPLATE_CACHE_EXPIRATION_TIMEOUT, "foo", false);
        this.testValue((ConfigurationKey)EngineConfigurationKey.TEMPLATE_CACHE_EXPIRATION_TIMEOUT, 10L, true);
        this.testValue((ConfigurationKey)EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT, false, false);
        this.testValue((ConfigurationKey)EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT, 10, true);
        this.testValue(ReflectionResolver.MEMBER_CACHE_MAX_SIZE_KEY, "nonsense", false);
        this.testValue(ReflectionResolver.MEMBER_CACHE_MAX_SIZE_KEY, 10L, true);
        final ConfigurationKey key = new ConfigurationKey(){

            public Object getDefaultValue() {
                return new Date();
            }

            public String get() {
                return "invalid_default_value_type";
            }
        };
        this.testValue(key, new Date(), false, (Resolver)new AbstractResolver(10){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                return null;
            }

            public Set<ConfigurationKey> getConfigurationKeys() {
                return Collections.singleton(key);
            }
        });
    }

    private void testValue(ConfigurationKey key, Object value, boolean shouldBeValid) {
        this.testValue(key, value, shouldBeValid, null);
    }

    private void testValue(ConfigurationKey key, Object value, boolean shouldBeValid, Resolver dummyResolver) {
        block5: {
            try {
                MustacheEngineBuilder builder = MustacheEngineBuilder.newBuilder();
                if (dummyResolver != null) {
                    builder.addResolver(dummyResolver);
                }
                builder.setProperty(key, value).build();
                if (!shouldBeValid) {
                    Assert.fail((String)"Should be invalid");
                }
            }
            catch (MustacheException e) {
                if (shouldBeValid) {
                    Assert.fail((String)"Should be valid");
                }
                if (e.getCode().equals(MustacheProblem.CONFIG_PROPERTY_INVALID_VALUE)) break block5;
                Assert.fail();
            }
        }
    }
}

