/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.MustacheExceptionAssert;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelperValidator;

public class HelperValidatorTest {
    @Test
    public void testSplitHelperName() {
        this.assertHelperNameParts("name foo.bar", "name", "foo.bar");
        this.assertHelperNameParts("name  hash1=\"DD-MM-yyyy HH:mm\"", "name", "hash1=\"DD-MM-yyyy HH:mm\"");
        this.assertHelperNameParts("name key='value'", "name", "key='value'");
        this.assertHelperNameParts("name key=''value''", "name", "key=''value''");
        this.assertHelperNameParts("key='value foo=' 'bar'", "key='value foo='", "'bar'");
        this.assertHelperNameParts("'key'='value foo=' 'bar'", "'key'='value foo='", "'bar'");
        this.assertHelperNameParts("foo='bar = \n baz' qux", "foo='bar = \n baz'", "qux");
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(new Runnable(){

            @Override
            public void run() {
                HelperValidatorTest.this.assertHelperNameParts("name key=''value'", new String[0]);
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                HelperValidatorTest.this.assertHelperNameParts("name key=value'", new String[0]);
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                HelperValidatorTest.this.assertHelperNameParts("name key='value foo", new String[0]);
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                HelperValidatorTest.this.assertHelperNameParts("name key=value' foo", new String[0]);
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                HelperValidatorTest.this.assertHelperNameParts("'name key=value", new String[0]);
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                HelperValidatorTest.this.assertHelperNameParts("key=\"value \" and\"", new String[0]);
            }
        });
    }

    @Test
    public void testGetFirstDeterminingEqualsCharPosition() {
        Assert.assertEquals((long)3L, (long)HelperValidator.getFirstDeterminingEqualsCharPosition((String)"foo=bar"));
        Assert.assertEquals((long)3L, (long)HelperValidator.getFirstDeterminingEqualsCharPosition((String)"foo='bar='"));
        Assert.assertEquals((long)-1L, (long)HelperValidator.getFirstDeterminingEqualsCharPosition((String)"'m=n'"));
        Assert.assertEquals((long)-1L, (long)HelperValidator.getFirstDeterminingEqualsCharPosition((String)" ' m=n'"));
    }

    private void assertHelperNameParts(String name, String ... parts) {
        Assert.assertTrue((String)("Parts: " + Arrays.toString(parts) + " != " + Iterators.toString((Iterator)HelperValidator.splitHelperName((String)name, null))), (boolean)Iterators.elementsEqual((Iterator)HelperValidator.splitHelperName((String)name, null), (Iterator)Iterators.forArray((Object[])parts)));
    }
}

