/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.cache.ComputingCacheFactory;
import org.trimou.engine.config.AbstractConfigurationAware;

public class DefaultComputingCacheFactory
extends AbstractConfigurationAware
implements ComputingCacheFactory {
    @Override
    public <K, V> ComputingCache<K, V> create(String consumerId, ComputingCache.Function<K, V> computingFunction, Long expirationTimeout, Long maxSize, final ComputingCache.Listener<K> listener) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (expirationTimeout != null && expirationTimeout > 0L) {
            builder.expireAfterWrite(expirationTimeout.longValue(), TimeUnit.MILLISECONDS);
        }
        if (maxSize != null) {
            builder.maximumSize(maxSize.longValue());
        }
        if (listener != null) {
            builder.removalListener(new RemovalListener<K, V>(){

                public void onRemoval(RemovalNotification<K, V> notification) {
                    listener.entryInvalidated(notification.getKey(), notification.getCause().toString());
                }
            });
        }
        return new LoadingCacheAdapter(builder.build(new CacheLoaderAdapter<K, V>(computingFunction)));
    }

    protected static class CacheLoaderAdapter<K, V>
    extends CacheLoader<K, V> {
        private final ComputingCache.Function<K, V> computingFunction;

        protected CacheLoaderAdapter(ComputingCache.Function<K, V> computingFunction) {
            this.computingFunction = computingFunction;
        }

        public V load(K key) throws Exception {
            return this.computingFunction.compute(key);
        }
    }

    protected static class LoadingCacheAdapter<K, V>
    implements ComputingCache<K, V> {
        private final LoadingCache<K, V> cache;

        protected LoadingCacheAdapter(LoadingCache<K, V> cache) {
            this.cache = cache;
        }

        @Override
        public V get(K key) {
            return (V)this.cache.getUnchecked(key);
        }

        @Override
        public V getIfPresent(K key) {
            return (V)this.cache.getIfPresent(key);
        }

        @Override
        public void clear() {
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }

        @Override
        public long size() {
            return this.cache.size();
        }

        @Override
        public void invalidate(ComputingCache.KeyPredicate<K> keyPredicate) {
            Iterator iterator = this.cache.asMap().keySet().iterator();
            while (iterator.hasNext()) {
                if (!keyPredicate.apply(iterator.next())) continue;
                iterator.remove();
            }
        }

        @Override
        public Map<K, V> getAllPresent() {
            return ImmutableMap.copyOf((Map)this.cache.asMap());
        }
    }
}

