/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.segment.IterationMeta;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Options;

public class EachHelper
extends BasicSectionHelper {
    private String iterationMetadataAlias;

    @Override
    public void init() {
        super.init();
        this.iterationMetadataAlias = this.configuration.getStringPropertyValue(EngineConfigurationKey.ITERATION_METADATA_ALIAS);
    }

    @Override
    public void execute(Options options) {
        Object value = options.getParameters().get(0);
        if (value instanceof Iterable) {
            this.processIterable((Iterable)value, options);
        } else if (value.getClass().isArray()) {
            this.processArray(value, options);
        } else {
            throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "%s is nor an Iterable nor an array [%s]", value, options.getTagInfo());
        }
    }

    private void processIterable(Iterable iterable, Options options) {
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        IterationMeta meta = new IterationMeta(this.iterationMetadataAlias, iterator);
        options.push(meta);
        while (iterator.hasNext()) {
            this.processIteration(options, iterator.next(), meta);
        }
        options.pop();
    }

    private void processArray(Object array, Options options) {
        int length = Array.getLength(array);
        if (length < 1) {
            return;
        }
        IterationMeta meta = new IterationMeta(this.iterationMetadataAlias, length);
        options.push(meta);
        for (int i = 0; i < length; ++i) {
            this.processIteration(options, Array.get(array, i), meta);
        }
        options.pop();
    }

    private void processIteration(Options options, Object value, IterationMeta meta) {
        options.push(value);
        options.fn();
        options.pop();
        meta.nextIteration();
    }
}

