/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicValueHelper;
import org.trimou.handlebars.Options;
import org.trimou.lambda.Lambda;

public class JoinHelper
extends BasicValueHelper {
    private static final Logger logger = LoggerFactory.getLogger(JoinHelper.class);

    @Override
    public void execute(Options options) {
        Object delimiter = this.getHashValue(options, "delimiter");
        Lambda lambda = this.initLambda(options);
        if (options.getParameters().size() == 1) {
            this.processValue(options, options.getParameters().get(0), delimiter, lambda);
        } else {
            Iterator<Object> iterator = options.getParameters().iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                this.processValue(options, value, delimiter, lambda);
                if (!iterator.hasNext() || delimiter == null) continue;
                this.append(options, delimiter, null);
            }
        }
    }

    private void processValue(Options options, Object value, Object delimiter, Lambda lambda) {
        if (value == null) {
            return;
        }
        if (value instanceof Iterable) {
            this.processIterable(options, (Iterable)value, delimiter, lambda);
        } else if (value.getClass().isArray()) {
            this.processArray(options, value, delimiter, lambda);
        } else {
            this.append(options, value, lambda);
        }
    }

    private void processIterable(Options options, Iterable iterable, Object delimiter, Lambda lambda) {
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            this.append(options, iterator.next(), lambda);
            if (delimiter == null || !iterator.hasNext()) continue;
            this.append(options, delimiter, null);
        }
    }

    private void processArray(Options options, Object array, Object delimiter, Lambda lambda) {
        int length = Array.getLength(array);
        if (length < 1) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.append(options, Array.get(array, i), lambda);
            if (delimiter == null || i + 1 >= length) continue;
            this.append(options, delimiter, null);
        }
    }

    private void append(Options options, Object value, Lambda lambda) {
        this.append(options, lambda != null ? lambda.invoke(value.toString()) : value.toString());
    }

    private Lambda initLambda(Options options) {
        Object lambdaReference = this.getHashValue(options, "lambda");
        if (lambdaReference == null) {
            return null;
        }
        if (lambdaReference instanceof Lambda) {
            Lambda lambda = (Lambda)lambdaReference;
            if (lambda.isReturnValueInterpolated() || lambda.getInputType().equals((Object)Lambda.InputType.PROCESSED)) {
                logger.warn("The lambda is processed as with InputType#LITERAL and Lambda#isReturnValueInterpolated() set to false [{}]", (Object)options.getTagInfo());
            }
            return lambda;
        }
        throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "%s is not a valid Lambda reference [%s]", lambdaReference, options.getTagInfo());
    }
}

