/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class ExtendSegmentTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
    }

    @Test
    public void testSimpleInheritance() {
        MapTemplateLocator locator = new MapTemplateLocator((Map)ImmutableMap.of((Object)"super", (Object)"Hello {{$insert}}Martin{{/insert}}", (Object)"sub", (Object)"And now... {{<super}} {{$insert}}{{name}}{{/insert}} {{/super}}!"));
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).build();
        Mustache sub = engine.getMustache("sub");
        Assert.assertEquals((Object)"And now... Hello Edgar!", (Object)sub.render((Object)ImmutableMap.of((Object)"name", (Object)"Edgar")));
    }

    @Test
    public void testMultipleInheritance() {
        MapTemplateLocator locator = new MapTemplateLocator((Map)ImmutableMap.of((Object)"super", (Object)"for {{$insert}}{{/insert}}", (Object)"sub", (Object)"And now {{<super}} {{$insert}}something {{$insert2}}{{/insert2}} different{{/insert}} {{/super}}.", (Object)"subsub", (Object)"{{<sub}} {{$insert2}}completely{{/insert2}} {{/sub}}"));
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).build();
        Mustache sub = engine.getMustache("subsub");
        Assert.assertEquals((Object)"And now for something completely different.", (Object)sub.render(null));
    }

    @Test
    public void testMultipleInheritanceOverride() {
        MapTemplateLocator locator = new MapTemplateLocator((Map)ImmutableMap.of((Object)"super", (Object)"{{$insert}}{{/insert}}", (Object)"sub", (Object)"{{<super}} {{$insert}}false{{/insert}} {{/super}}", (Object)"subsub", (Object)"{{<sub}} {{$insert}}true{{/insert}} {{/sub}}"));
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).build();
        Mustache sub = engine.getMustache("subsub");
        Assert.assertEquals((Object)"true", (Object)sub.render(null));
    }

    @Test
    public void testRecursiveInvocationAllowed() {
        MapTemplateLocator locator = new MapTemplateLocator((Map)ImmutableMap.of((Object)"super", (Object)"{{$content}}{{<super}}{{$content}}Mooo{{/content}}{{/super}}{{/content}}"));
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).setProperty((ConfigurationKey)EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT, (Object)5).build();
        Assert.assertEquals((Object)"Mooo", (Object)engine.getMustache("super").render(null));
    }

    @Test
    public void testRecursiveInvocationDisabled() {
        MapTemplateLocator locator = new MapTemplateLocator((Map)ImmutableMap.of((Object)"super", (Object)"{{$content}}{{<super}}{{$content}}Mooo{{/content}}{{/super}}{{/content}}"));
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).setProperty((ConfigurationKey)EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT, (Object)0).build();
        try {
            engine.getMustache("super").render(null);
            Assert.fail((String)"Limit exceeded and no exception thrown");
        }
        catch (MustacheException e) {
            if (!e.getCode().equals(MustacheProblem.RENDER_TEMPLATE_INVOCATION_RECURSIVE_LIMIT_EXCEEDED)) {
                Assert.fail((String)"Invalid problem");
            }
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testRecursiveInvocationLimitExceeded() {
        MapTemplateLocator locator = new MapTemplateLocator((Map)ImmutableMap.of((Object)"super", (Object)"/n{{<super}}{{/super}}"));
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).setProperty((ConfigurationKey)EngineConfigurationKey.TEMPLATE_RECURSIVE_INVOCATION_LIMIT, (Object)5).build();
        try {
            engine.getMustache("super").render(null);
            Assert.fail((String)"Limit exceeded and no exception thrown");
        }
        catch (MustacheException e) {
            if (!e.getCode().equals(MustacheProblem.RENDER_TEMPLATE_INVOCATION_RECURSIVE_LIMIT_EXCEEDED)) {
                Assert.fail((String)"Invalid problem");
            }
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testExtendNotFound() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().build();
        try {
            engine.compileMustache("extend_not_found", "Hello,\nan attempt to extend \n\n {{<neverexisted}}{{/neverexisted}}").render(null);
            Assert.fail((String)"Template to extend does not exist!");
        }
        catch (MustacheException e) {
            if (!e.getCode().equals(MustacheProblem.RENDER_INVALID_EXTEND_KEY)) {
                Assert.fail((String)"Invalid problem");
            }
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testMultipleExtendSegments() {
        MapTemplateLocator locator = new MapTemplateLocator((Map)ImmutableMap.of((Object)"super", (Object)"{{$insert}}baz{{/insert}}", (Object)"sub", (Object)"{{<super}}{{$insert}}foo{{/insert}}{{/super}}{{<super}}{{$insert}}bar{{/insert}}{{/super}}"));
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).build();
        Mustache sub = engine.getMustache("sub");
        Assert.assertEquals((Object)"foobar", (Object)sub.render(null));
    }

    @Test
    public void testCachedPartialSegmentUsed() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("super", "{{$section1}}Martin{{/section1}}");
        map.put("sub", "{{<super}}{{$section1}}{{this}}{{/section1}}{{/super}}");
        MapTemplateLocator locator = new MapTemplateLocator(map);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).build();
        Mustache mustache = engine.getMustache("sub");
        Assert.assertEquals((Object)"foo", (Object)mustache.render((Object)"foo"));
        map.put("super", "{{$section2}}Martin{{/section2}}");
        engine.invalidateTemplateCache();
        Assert.assertEquals((Object)"foo", (Object)mustache.render((Object)"foo"));
    }

    @Test
    public void testCachedPartialSegmentNotUsed() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("super", "{{$section1}}Martin{{/section1}}");
        map.put("sub", "{{<super}}{{$section1}}{{this}}{{/section1}}{{/super}}");
        MapTemplateLocator locator = new MapTemplateLocator(map);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)locator).setProperty((ConfigurationKey)EngineConfigurationKey.DEBUG_MODE, (Object)true).build();
        Mustache mustache = engine.getMustache("sub");
        Assert.assertEquals((Object)"foo", (Object)mustache.render((Object)"foo"));
        map.put("super", "{{$section2}}Martin{{/section2}}");
        engine.invalidateTemplateCache();
        Assert.assertEquals((Object)"Martin", (Object)mustache.render((Object)"foo"));
    }
}

