/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.ArchiveType;
import org.trimou.Hammer;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;

public class EqualsHelperTest
extends AbstractTest {
    @Test
    public void testEqualsHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addGlobalData("archiveType", ArchiveType.class).registerHelpers(HelpersBuilder.empty().addIsEqual().addIsNotEqual().build()).build();
        Assert.assertEquals((Object)"EQUALS", (Object)engine.compileMustache("equals_helper1", "{{#isEq this.age this.age}}EQUALS{{/isEq}}").render((Object)new Hammer()));
        Assert.assertEquals((Object)"EQUALS", (Object)engine.compileMustache("equals_helper2", "{{#isEq this}}EQUALS{{/isEq}}").render((Object)new Hammer()));
        Assert.assertEquals((Object)"NOT_EQUALS", (Object)engine.compileMustache("equals_helper3", "{{#isNotEq this.age}}NOT_EQUALS{{/isNotEq}}").render((Object)new Hammer()));
        Assert.assertEquals((Object)"NOT_EQUALS", (Object)engine.compileMustache("equals_helper4", "{{#isNotEq this.age this.toString}}NOT_EQUALS{{/isNotEq}}").render((Object)new Hammer()));
        Assert.assertEquals((Object)"It's a WAR!", (Object)engine.compileMustache("equals_helper5", "{{#with this.archiveType}}{{#isEq archiveType.WAR}}It's a WAR!{{/isEq}}{{#isEq archiveType.EAR}}It's an EAR!{{/isEq}}{{/with}}").render((Object)new Hammer()));
    }

    @Test
    public void testEqualsHelperValidation() {
        final MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addIsEqual().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("equals_helper_validation01", "{{#isEq}}{{/isEq}}");
            }
        });
    }
}

