/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.interpolation;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.interpolation.LiteralSupport;
import org.trimou.util.Patterns;
import org.trimou.util.Strings;

public class DefaultLiteralSupport
extends AbstractConfigurationAware
implements LiteralSupport {
    private final Pattern integerLiteralPattern = Patterns.newHelperIntegerLiteralPattern();

    @Override
    public Object getLiteral(String value, MustacheTagInfo tagInfo) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        Object literal = null;
        if (Strings.isStringLiteralSeparator(value.charAt(0))) {
            literal = value.substring(1, value.length() - 1);
        } else if (this.integerLiteralPattern.matcher(value).matches()) {
            try {
                literal = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return literal;
    }
}

