/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.parser.Template;
import org.trimou.engine.resolver.EnhancedResolver;
import org.trimou.engine.segment.AbstractSegment;
import org.trimou.engine.segment.HelperAwareSegment;
import org.trimou.engine.segment.HelperExecutionHandler;
import org.trimou.engine.segment.Lambdas;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.text.TextSupport;
import org.trimou.lambda.Lambda;

@Internal
public class ValueSegment
extends AbstractSegment
implements HelperAwareSegment {
    private final boolean unescape;
    private final HelperExecutionHandler helperHandler;
    private final TextSupport textSupport;
    private final String[] keyParts;
    private final AtomicReference<EnhancedResolver.Hint> hint;

    public ValueSegment(String text, Origin origin, boolean unescape) {
        super(text, origin);
        this.unescape = unescape;
        HelperExecutionHandler helperExecutionHandler = this.helperHandler = this.isHandlebarsSupportEnabled() ? HelperExecutionHandler.from(text, this.getEngine(), this) : null;
        if (this.helperHandler == null) {
            this.textSupport = this.getEngineConfiguration().getTextSupport();
            ArrayList<String> parts = new ArrayList<String>();
            Iterator<String> iterator = this.getEngineConfiguration().getKeySplitter().split(text);
            while (iterator.hasNext()) {
                parts.add(iterator.next());
            }
            this.keyParts = parts.toArray(new String[parts.size()]);
            this.hint = this.getEngineConfiguration().getBooleanPropertyValue(EngineConfigurationKey.RESOLVER_HINTS_ENABLED).booleanValue() ? new AtomicReference() : null;
        } else {
            this.textSupport = null;
            this.keyParts = null;
            this.hint = null;
        }
    }

    @Override
    public SegmentType getType() {
        return SegmentType.VALUE;
    }

    public boolean isUnescape() {
        return this.unescape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Appendable execute(Appendable appendable, ExecutionContext context) {
        if (this.helperHandler != null) {
            return this.helperHandler.execute(appendable, context);
        }
        ValueWrapper value = context.getValue(this.getText(), this.keyParts, this.hint);
        try {
            if (value.isNull()) {
                Object replacement = this.getEngineConfiguration().getMissingValueHandler().handle(this.getTagInfo());
                if (replacement != null) {
                    this.processValue(appendable, context, replacement);
                }
            } else {
                if (this.hint != null && value.getHint() != null) {
                    this.hint.compareAndSet(null, value.getHint());
                }
                this.processValue(appendable, context, value.get());
            }
        }
        finally {
            value.release();
        }
        return appendable;
    }

    @Override
    public Appendable fn(Appendable appendable, ExecutionContext context) {
        return appendable;
    }

    @Override
    protected String getSegmentName() {
        return this.getText();
    }

    @Override
    protected MustacheTagType getTagType() {
        return this.unescape ? MustacheTagType.UNESCAPE_VARIABLE : MustacheTagType.VARIABLE;
    }

    private void processValue(Appendable appendable, ExecutionContext context, Object value) {
        if (value instanceof Lambda) {
            this.processLambda(appendable, context, value);
        } else {
            this.writeValue(appendable, value.toString());
        }
    }

    private void writeValue(Appendable appendable, String text) {
        this.append(appendable, this.unescape ? text : this.textSupport.escapeHtml(text));
    }

    private void processLambda(Appendable appendable, ExecutionContext context, Object value) {
        Lambda lambda = (Lambda)value;
        String returnValue = lambda.invoke(null);
        if (returnValue == null) {
            Object replacement = this.getEngineConfiguration().getMissingValueHandler().handle(this.getTagInfo());
            if (replacement != null) {
                this.processValue(appendable, context, replacement);
                return;
            }
        } else if (!returnValue.equals("")) {
            if (lambda.isReturnValueInterpolated()) {
                StringBuilder interpolated = new StringBuilder();
                Template temp = (Template)this.getEngine().compileMustache(Lambdas.constructLambdaOneoffTemplateName(this), returnValue);
                temp.getRootSegment().execute(interpolated, context);
                this.writeValue(appendable, interpolated.toString());
            } else {
                this.writeValue(appendable, returnValue);
            }
        }
    }
}

