/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars.i18n;

import com.google.common.collect.ImmutableMap;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.locale.FixedLocaleSupport;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.i18n.DateTimeFormatHelper;

public class DateTimeFormatHelperTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
        this.engine = MustacheEngineBuilder.newBuilder().registerHelper("formatTime", (Helper)new DateTimeFormatHelper()).setLocaleSupport((LocaleSupport)FixedLocaleSupport.from((Locale)Locale.ENGLISH)).build();
    }

    @Test
    public void testInterpolation() {
        Calendar day = Calendar.getInstance();
        day.set(1, 2013);
        day.set(2, 0);
        day.set(5, 1);
        day.set(11, 13);
        day.set(12, 0);
        day.set(13, 0);
        day.set(14, 0);
        long milis = day.getTimeInMillis();
        String expectedShort = "1/1/13 1:00 PM";
        String expectedMedium = "Jan 1, 2013 1:00:00 PM";
        String expectedCustom = "01-01-2013 13:00";
        ImmutableMap data = ImmutableMap.of((Object)"calendar", (Object)day, (Object)"date", (Object)day.getTime(), (Object)"milis", (Object)milis);
        Assert.assertEquals((Object)StringUtils.repeat((String)expectedMedium, (String)"|", (int)3), (Object)this.engine.compileMustache("date_time_helper_medium", "{{formatTime calendar style=\"medium\"}}|{{formatTime date style=\"medium\"}}|{{formatTime milis style=\"medium\"}}").render((Object)data));
        Assert.assertEquals((Object)StringUtils.repeat((String)expectedShort, (String)"|", (int)3), (Object)this.engine.compileMustache("date_time_helper_short", "{{formatTime calendar style=\"short\"}}|{{formatTime date style=\"short\"}}|{{formatTime milis style=\"short\"}}").render((Object)data));
        Assert.assertEquals((Object)StringUtils.repeat((String)expectedCustom, (String)"|", (int)3), (Object)this.engine.compileMustache("date_time_helper_custom", "{{formatTime calendar pattern=\"DD-MM-yyyy HH:mm\"}}|{{formatTime date pattern=\"DD-MM-yyyy HH:mm\"}}|{{formatTime milis pattern=\"DD-MM-yyyy HH:mm\"}}").render((Object)data));
    }
}

