/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import org.trimou.engine.locator.AbstractTemplateLocator;

public class MapTemplateLocator
extends AbstractTemplateLocator {
    private final Map<String, String> templates;

    public MapTemplateLocator(int priority, Map<String, String> templates) {
        super(priority);
        this.templates = templates;
    }

    public MapTemplateLocator(Map<String, String> templates) {
        super(10);
        this.templates = templates;
    }

    @Override
    public Reader locate(String templateName) {
        String templateContent = this.templates.get(templateName);
        if (templateContent != null) {
            return new StringReader(templateContent);
        }
        return null;
    }

    @Override
    public Set<String> getAllIdentifiers() {
        return this.templates.keySet();
    }

    public String toString() {
        return String.format("%s [priority: %s]", this.getClass().getName(), this.getPriority());
    }
}

