/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Set;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.segment.ImmutableIterationMeta;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Function;
import org.trimou.handlebars.Options;

public class EachHelper
extends BasicSectionHelper {
    public static final String SKIP_RESULT = "org.trimou.handlebars.skipResult";
    private String iterationMetadataAlias;

    @Override
    public void init() {
        super.init();
        this.iterationMetadataAlias = this.configuration.getStringPropertyValue(EngineConfigurationKey.ITERATION_METADATA_ALIAS);
    }

    @Override
    public void execute(Options options) {
        Object value = options.getParameters().get(0);
        if (value == null) {
            return;
        }
        if (value instanceof Iterable) {
            this.processIterable((Iterable)value, options);
        } else if (value.getClass().isArray()) {
            this.processArray(value, options);
        } else {
            throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "%s is nor an Iterable nor an array [%s]", value, options.getTagInfo());
        }
    }

    @Override
    protected Optional<Set<String>> getSupportedHashKeys() {
        return Optional.of((Object)ImmutableSet.of((Object)"apply", (Object)"as"));
    }

    private void processIterable(Iterable iterable, Options options) {
        int size = Iterables.size((Iterable)iterable);
        if (size < 1) {
            return;
        }
        Iterator iterator = iterable.iterator();
        int i = 1;
        while (iterator.hasNext()) {
            this.nextElement(options, iterator.next(), size, i++, this.initFunction(options), this.initValueAlias(options));
        }
    }

    private void processArray(Object array, Options options) {
        int length = Array.getLength(array);
        if (length < 1) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.nextElement(options, Array.get(array, i), length, i + 1, this.initFunction(options), this.initValueAlias(options));
        }
    }

    private void nextElement(Options options, Object value, int size, int index, Function function, String valueAlias) {
        if (function != null && SKIP_RESULT.equals(value = function.apply(value))) {
            return;
        }
        if (valueAlias != null) {
            options.push(new ImmutableIterationMeta(this.iterationMetadataAlias, size, index, valueAlias, value));
            options.fn();
            options.pop();
        } else {
            options.push(new ImmutableIterationMeta(this.iterationMetadataAlias, size, index));
            options.push(value);
            options.fn();
            options.pop();
            options.pop();
        }
    }

    private Function initFunction(Options options) {
        Object function = this.getHashValue(options, "apply");
        if (function == null) {
            return null;
        }
        if (function instanceof Function) {
            return (Function)function;
        }
        throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "%s is not a valid function [%s]", function, options.getTagInfo());
    }

    private String initValueAlias(Options options) {
        Object as = this.getHashValue(options, "as");
        if (as == null) {
            return null;
        }
        return as.toString();
    }
}

