/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.segment.Segment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicHelper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.util.Checker;
import org.trimou.util.Strings;

public final class HelperValidator {
    private static final Logger logger = LoggerFactory.getLogger(HelperValidator.class);

    private HelperValidator() {
    }

    public static void checkParams(Class<?> helperClazz, HelperDefinition definition, int paramSize) {
        Checker.checkArgumentNotNull(definition);
        Preconditions.checkArgument((paramSize >= 0 ? 1 : 0) != 0, (Object)"Helper may only require zero or more params");
        int size = definition.getParameters().size();
        if (size < paramSize) {
            throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, "Insufficient number of parameters for helper %s [expected: %s, current: %s, template: %s, line: %s]", helperClazz.getName(), paramSize, size, definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine());
        }
        if (size > paramSize) {
            logger.trace("{} superfluous parameters detected [helper: {}, template: {}, line: {}]", new Object[]{size - paramSize, helperClazz.getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine()});
        }
    }

    public static void checkType(Class<?> helperClazz, HelperDefinition definition, MustacheTagType ... allowedTypes) {
        Checker.checkArgumentsNotNull(new Object[]{definition, allowedTypes});
        if (!ArrayUtils.contains((Object[])allowedTypes, (Object)((Object)definition.getTagInfo().getType()))) {
            throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, "Unsupported tag type [helper: %s, template: %s, line: %s]", helperClazz.getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine());
        }
    }

    public static void checkHash(Class<?> helperClazz, HelperDefinition definition, int hashSize) {
        Checker.checkArgumentNotNull(definition);
        Preconditions.checkArgument((hashSize >= 0 ? 1 : 0) != 0, (Object)"Helper may only require zero or more hash entries");
        int size = definition.getHash().size();
        if (size < hashSize) {
            throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, "Insufficient number of hash entries for helper %s [expected: %s, current: %s, template: %s, line: %s]", helperClazz.getName(), hashSize, size, definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine());
        }
        if (size > hashSize) {
            logger.trace("{} superfluous hash entries detected [helper: {}, template: {}, line: {}]", new Object[]{size - hashSize, helperClazz.getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine()});
        }
    }

    public static void checkHash(HelperDefinition definition, BasicHelper helper) {
        HelperValidator.checkHash(helper.getClass(), definition, helper.numberOfRequiredHashEntries());
        Optional<Set<String>> supportedHashKeys = helper.getSupportedHashKeys();
        if (supportedHashKeys.isPresent()) {
            for (String key : definition.getHash().keySet()) {
                if (((Set)supportedHashKeys.get()).contains(key)) continue;
                logger.info("Unsupported hash key detected [key: {}, helper: {}, template: {}, line: {}]", new Object[]{key, helper.getClass().getName(), definition.getTagInfo().getTemplateName(), definition.getTagInfo().getLine()});
            }
        }
    }

    @Internal
    public static Iterator<String> splitHelperName(String name, Segment segment) {
        boolean stringLiteral = false;
        boolean space = false;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ' ') {
                if (space) continue;
                if (!stringLiteral) {
                    if (buffer.length() > 0) {
                        parts.add(buffer.toString());
                        buffer = new StringBuilder();
                    }
                    space = true;
                    continue;
                }
                buffer.append(name.charAt(i));
                continue;
            }
            if (Strings.isStringLiteralSeparator(name.charAt(i))) {
                stringLiteral = !stringLiteral;
            }
            space = false;
            buffer.append(name.charAt(i));
        }
        if (buffer.length() > 0) {
            if (stringLiteral) {
                throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, "Unterminated string literal detected: %s", segment);
            }
            parts.add(buffer.toString());
        }
        return parts.iterator();
    }

    public static int getFirstDeterminingEqualsCharPosition(String part) {
        boolean stringLiteral = false;
        for (int i = 0; i < part.length(); ++i) {
            if (Strings.isStringLiteralSeparator(part.charAt(i))) {
                if (i == 0) {
                    return -1;
                }
                stringLiteral = !stringLiteral;
                continue;
            }
            if (stringLiteral || part.charAt(i) != '=') continue;
            return i;
        }
        return -1;
    }
}

