/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.MustacheTagType;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Flow;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.Options;

public class SwitchHelper
extends BasicSectionHelper {
    private static final Logger logger = LoggerFactory.getLogger(SwitchHelper.class);

    @Override
    protected int numberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void execute(Options options) {
        Object value;
        Object object = value = options.getParameters().isEmpty() ? options.peek() : options.getParameters().get(0);
        if (value == null) {
            return;
        }
        options.push(new Flow(value));
        options.fn();
        options.pop();
    }

    @Override
    protected Optional<Set<String>> getSupportedHashKeys() {
        return NO_SUPPORTED_HASH_KEYS;
    }

    @Override
    public void validate(HelperDefinition definition) {
        super.validate(definition);
        HashSet<String> validNames = new HashSet<String>(4);
        for (Map.Entry<String, Helper> entry : this.configuration.getHelpers().entrySet()) {
            if (!(entry.getValue() instanceof CaseHelper) && !(entry.getValue() instanceof DefaultHelper)) continue;
            validNames.add(entry.getKey());
        }
        for (MustacheTagInfo info : definition.getTagInfo().getChildTags()) {
            if (this.isValid(info, validNames)) continue;
            logger.warn("Invalid content detected {}. This helper should only contain case and default sections. Other types of segments are always rendered!", (Object)info);
        }
    }

    private boolean isValid(MustacheTagInfo info, Set<String> validNames) {
        if (!info.getType().equals((Object)MustacheTagType.SECTION)) {
            return false;
        }
        for (String name : validNames) {
            if (!info.getText().startsWith(name)) continue;
            return true;
        }
        return false;
    }

    public static class DefaultHelper
    extends BasicSectionHelper {
        @Override
        protected int numberOfRequiredParameters() {
            return 0;
        }

        @Override
        public void execute(Options options) {
            Object contextObject = options.peek();
            if (contextObject instanceof Flow) {
                Flow flow = (Flow)contextObject;
                if (!flow.isTerminated()) {
                    options.fn();
                    flow.terminate();
                }
            } else {
                throw Flow.newInvalidFlowException(options.getTagInfo());
            }
        }

        @Override
        protected Optional<Set<String>> getSupportedHashKeys() {
            return NO_SUPPORTED_HASH_KEYS;
        }
    }

    public static class CaseHelper
    extends BasicSectionHelper {
        private final boolean defaultIsBreak;

        public CaseHelper() {
            this(false);
        }

        public CaseHelper(boolean defaultIsBreak) {
            this.defaultIsBreak = defaultIsBreak;
        }

        @Override
        public void execute(Options options) {
            Object contextObject = options.peek();
            if (contextObject instanceof Flow) {
                Flow flow = (Flow)contextObject;
                if (!flow.isTerminated() && (flow.isFallThrough() || flow.up().equals(options.getParameters().get(0)))) {
                    options.fn();
                    flow.setFallThrough();
                    if (this.isBreak(options.getHash())) {
                        flow.terminate();
                    }
                }
            } else {
                throw Flow.newInvalidFlowException(options.getTagInfo());
            }
        }

        @Override
        protected Optional<Set<String>> getSupportedHashKeys() {
            return Optional.of(Collections.singleton("break"));
        }

        private boolean isBreak(Map<String, Object> hash) {
            if (hash.isEmpty() || !hash.containsKey("break")) {
                return this.defaultIsBreak;
            }
            return Boolean.valueOf(hash.get("break").toString());
        }
    }
}

