/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.io.IOException;
import java.io.Writer;
import org.trimou.annotations.Internal;

@Internal
public class StringBuilderWriter
extends Writer {
    private final StringBuilder builder;

    public StringBuilderWriter(StringBuilder builder) {
        this.builder = builder;
    }

    public StringBuilderWriter() {
        this.builder = new StringBuilder();
    }

    public StringBuilderWriter(int capacity) {
        this.builder = new StringBuilder(capacity);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.builder.append(cbuf, off, len);
    }

    @Override
    public void write(int c) {
        this.builder.append((char)c);
    }

    @Override
    public void write(char[] cbuf) {
        this.builder.append(cbuf);
    }

    @Override
    public void write(String str) throws IOException {
        if (str != null) {
            this.builder.append(str);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (str != null) {
            this.builder.append(str, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.builder.toString();
    }
}

