/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import org.trimou.annotations.Internal;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.AbstractSectionSegment;
import org.trimou.engine.segment.HelperAwareSegment;
import org.trimou.engine.segment.HelperExecutionHandler;
import org.trimou.engine.segment.ImmutableIterationMeta;
import org.trimou.engine.segment.Lambdas;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.ValueProvider;
import org.trimou.handlebars.HelperValidator;
import org.trimou.lambda.Lambda;

@Internal
public class SectionSegment
extends AbstractSectionSegment
implements HelperAwareSegment {
    private final String iterationMetaAlias;
    private final HelperExecutionHandler helperHandler;
    private final ValueProvider provider;

    public SectionSegment(String text, Origin origin, List<Segment> segments) {
        super(text, origin, segments);
        HelperExecutionHandler helperExecutionHandler = this.helperHandler = this.isHandlebarsSupportEnabled() ? HelperExecutionHandler.from(text, this.getEngine(), this) : null;
        if (this.helperHandler == null) {
            this.iterationMetaAlias = this.getEngineConfiguration().getStringPropertyValue(EngineConfigurationKey.ITERATION_METADATA_ALIAS);
            this.provider = new ValueProvider(text, this.getEngineConfiguration());
        } else {
            this.iterationMetaAlias = null;
            this.provider = null;
        }
    }

    @Override
    public SegmentType getType() {
        return SegmentType.SECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Appendable execute(Appendable appendable, ExecutionContext context) {
        if (this.helperHandler != null) {
            return this.helperHandler.execute(appendable, context);
        }
        ValueWrapper value = this.provider.get(context);
        try {
            if (value.isNull()) {
                Appendable appendable2 = appendable;
                return appendable2;
            }
            this.processValue(appendable, context, value.get());
        }
        finally {
            value.release();
        }
        return appendable;
    }

    @Override
    public Appendable fn(Appendable appendable, ExecutionContext context) {
        return super.execute(appendable, context);
    }

    @Override
    public String getLiteralBlock() {
        StringBuilder literal = new StringBuilder();
        literal.append(this.getTagLiteral(this.getType().getTagType().getCommand() + this.getText()));
        literal.append(this.getContentLiteralBlock());
        if (this.helperHandler != null) {
            literal.append(this.getTagLiteral(MustacheTagType.SECTION_END.getCommand() + HelperValidator.splitHelperName(this.getText(), this).next()));
        } else {
            literal.append(this.getTagLiteral(MustacheTagType.SECTION_END.getCommand() + this.getText()));
        }
        return literal.toString();
    }

    private void processValue(Appendable appendable, ExecutionContext context, Object value) {
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                super.execute(appendable, context);
            }
        } else if (value instanceof Iterable) {
            this.processIterable(appendable, context, value);
        } else if (value.getClass().isArray()) {
            this.processArray(appendable, context, value);
        } else if (value instanceof Lambda) {
            this.processLambda(appendable, context, value);
        } else {
            super.execute(appendable, context.setContextObject(value));
        }
    }

    private void processIterable(Appendable appendable, ExecutionContext context, Object value) {
        Iterable iterable = (Iterable)value;
        int size = Iterables.size((Iterable)iterable);
        if (size < 1) {
            return;
        }
        Iterator iterator = iterable.iterator();
        int i = 1;
        while (iterator.hasNext()) {
            this.processIteration(appendable, context.setContextObject(new ImmutableIterationMeta(this.iterationMetaAlias, size, i++)), iterator.next());
        }
    }

    private void processArray(Appendable appendable, ExecutionContext context, Object array) {
        int length = Array.getLength(array);
        if (length < 1) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.processIteration(appendable, context.setContextObject(new ImmutableIterationMeta(this.iterationMetaAlias, length, i + 1)), Array.get(array, i));
        }
    }

    private void processIteration(Appendable appendable, ExecutionContext context, Object value) {
        super.execute(appendable, context.setContextObject(value));
    }

    private void processLambda(Appendable appendable, ExecutionContext context, Object value) {
        String input;
        Lambda lambda = (Lambda)value;
        switch (lambda.getInputType()) {
            case LITERAL: {
                input = this.getContentLiteralBlock();
                break;
            }
            case PROCESSED: {
                StringBuilder processed = new StringBuilder();
                super.execute(processed, context);
                input = processed.toString();
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported lambda input type");
            }
        }
        String returnValue = lambda.invoke(input);
        if (lambda.isReturnValueInterpolated()) {
            Template temp = (Template)this.getEngine().compileMustache(Lambdas.constructLambdaOneoffTemplateName(this), returnValue);
            temp.getRootSegment().execute(appendable, context);
        } else {
            this.append(appendable, returnValue);
        }
    }
}

