/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.AbstractContainerSegment;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;

final class Segments {
    private Segments() {
    }

    static boolean isTemplateCachingAllowed(Configuration configuration) {
        return configuration.getBooleanPropertyValue(EngineConfigurationKey.DEBUG_MODE) == false && configuration.getBooleanPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_ENABLED) != false && configuration.getLongPropertyValue(EngineConfigurationKey.TEMPLATE_CACHE_EXPIRATION_TIMEOUT) <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Template getTemplate(AtomicReference<Template> cachedReference, String templateId, MustacheEngine engine) {
        if (cachedReference != null) {
            Template template = cachedReference.get();
            if (template == null) {
                AtomicReference<Template> atomicReference = cachedReference;
                synchronized (atomicReference) {
                    if (template == null) {
                        template = (Template)engine.getMustache(templateId);
                        cachedReference.set(template);
                    }
                }
            }
            return template;
        }
        return (Template)engine.getMustache(templateId);
    }

    static List<List<Segment>> readSegmentLinesBeforeRendering(AbstractContainerSegment container) {
        ArrayList<List<Segment>> lines = new ArrayList<List<Segment>>();
        ArrayList<Segment> currentLine = new ArrayList<Segment>();
        for (Segment segment : container) {
            if (!SegmentType.LINE_SEPARATOR.equals((Object)segment.getType())) {
                currentLine.add(segment);
                continue;
            }
            currentLine.add(segment);
            lines.add(currentLine);
            currentLine = new ArrayList();
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines;
    }

    static String[] getKeyParts(String text, Configuration configuration) {
        ArrayList<String> parts = new ArrayList<String>();
        Iterator<String> iterator = configuration.getKeySplitter().split(text);
        while (iterator.hasNext()) {
            parts.add(iterator.next());
        }
        return parts.toArray(new String[parts.size()]);
    }
}

