/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.BasicHelper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.HelperValidator;
import org.trimou.handlebars.Options;
import org.trimou.handlebars.SecurityActions;

public class InvokeHelper
extends BasicHelper {
    public static final ConfigurationKey METHOD_CACHE_MAX_SIZE_KEY = new SimpleConfigurationKey(InvokeHelper.class.getName() + ".methodCacheMaxSize", 500L);
    private ComputingCache<MethodKey, Optional<Method>> methodCache;
    private final ClassLoader classLoader;

    public InvokeHelper() {
        ClassLoader cl = SecurityActions.getContextClassLoader();
        if (cl == null) {
            cl = SecurityActions.getClassLoader(InvokeHelper.class);
        }
        this.classLoader = cl;
    }

    public InvokeHelper(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void execute(Options options) {
        Method method;
        Object instance;
        Class<?> clazz = null;
        Object methodName = this.getHashValue(options, "m");
        if (methodName == null) {
            methodName = this.getHashValue(options, "method");
        }
        if ((instance = this.getHashValue(options, "on")) == null && (clazz = this.loadClassIfNeeded(options)) == null) {
            instance = options.peek();
        }
        if (clazz == null) {
            clazz = instance.getClass();
        }
        if ((method = (Method)this.methodCache.get(new MethodKey(clazz, methodName.toString(), this.getParamTypes(options))).orNull()) == null) {
            throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_OPTIONS, "Unable to find unambiguous method with name \"%s\" and parameter types %s on class %s [%s]", methodName, this.getParamTypes(options), clazz.getName(), options.getTagInfo());
        }
        try {
            Object value = method.invoke(instance, options.getParameters().toArray());
            if (this.isSection(options)) {
                if (value != null) {
                    options.push(value);
                    options.fn();
                    options.pop();
                }
            } else {
                if (value == null) {
                    value = this.configuration.getMissingValueHandler().handle(options.getTagInfo());
                }
                if (value != null) {
                    this.append(options, value.toString());
                }
            }
        }
        catch (Exception e) {
            throw new MustacheException(MustacheProblem.RENDER_GENERIC_ERROR, (Throwable)e);
        }
    }

    @Override
    public void init() {
        super.init();
        this.methodCache = this.configuration.getComputingCacheFactory().create(InvokeHelper.class.getName(), new MethodComputingFunction(), null, this.configuration.getLongPropertyValue(METHOD_CACHE_MAX_SIZE_KEY), null);
    }

    @Override
    public Set<ConfigurationKey> getConfigurationKeys() {
        return super.getConfigurationKeys();
    }

    @Override
    protected int numberOfRequiredParameters() {
        return 0;
    }

    @Override
    public void validate(HelperDefinition definition) {
        super.validate(definition);
        if (!definition.getHash().containsKey("method") && !definition.getHash().containsKey("m")) {
            throw HelperValidator.newValidationException("A method name must be always defined", this.getClass(), definition);
        }
    }

    @Override
    protected Optional<Set<String>> getSupportedHashKeys() {
        return Optional.of((Object)ImmutableSet.of((Object)"on", (Object)"m", (Object)"method", (Object)"class"));
    }

    private static boolean matches(Method method, List<Class<?>> paramTypes) {
        Class<?>[] methodParamTypes = method.getParameterTypes();
        if (methodParamTypes.length != paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < methodParamTypes.length; ++i) {
            Class type = Primitives.wrap(methodParamTypes[i]);
            if (type.isAssignableFrom(paramTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    private List<Class<?>> getParamTypes(Options options) {
        int size = options.getParameters().size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList paramTypes = new ArrayList(size);
        for (Object param : options.getParameters()) {
            paramTypes.add(param.getClass());
        }
        return paramTypes;
    }

    private Class<?> loadClassIfNeeded(Options options) {
        Class<?> clazz = null;
        try {
            Object clazzValue = this.getHashValue(options, "class");
            if (clazzValue != null) {
                clazz = clazzValue instanceof Class ? (Class<?>)clazzValue : this.classLoader.loadClass(clazzValue.toString());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    private static List<Method> findMethods(Class<?> clazz, String name) {
        ArrayList<Method> found = new ArrayList<Method>();
        for (Method method : SecurityActions.getMethods(clazz)) {
            if (!name.equals(method.getName())) continue;
            found.add(method);
        }
        return found;
    }

    private static class MethodComputingFunction
    implements ComputingCache.Function<MethodKey, Optional<Method>> {
        private MethodComputingFunction() {
        }

        @Override
        public Optional<Method> compute(MethodKey key) {
            List found = InvokeHelper.findMethods(key.getClazz(), key.getName());
            if (found.isEmpty()) {
                return Optional.absent();
            }
            Iterator iterator = found.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                if (InvokeHelper.matches(method, key.getParamTypes())) continue;
                iterator.remove();
            }
            if (found.size() == 1) {
                Method method = (Method)found.get(0);
                if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
                    SecurityActions.setAccessible(method);
                }
                return Optional.of((Object)method);
            }
            return Optional.absent();
        }
    }

    private static final class MethodKey {
        private final Class<?> clazz;
        private final String name;
        private final List<Class<?>> paramTypes;

        private MethodKey(Class<?> clazz, String name, List<Class<?>> paramTypes) {
            this.clazz = clazz;
            this.name = name;
            this.paramTypes = paramTypes;
        }

        Class<?> getClazz() {
            return this.clazz;
        }

        String getName() {
            return this.name;
        }

        List<Class<?>> getParamTypes() {
            return this.paramTypes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.paramTypes == null ? 0 : this.paramTypes.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.paramTypes == null ? other.paramTypes != null : !this.paramTypes.equals(other.paramTypes));
        }
    }
}

