/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import java.util.Locale;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.listener.AbstractMustacheListener;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.locator.FileSystemTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.resolver.i18n.DateTimeFormatResolver;
import org.trimou.engine.text.TextSupport;

public class MustacheEngineBuilderTest
extends AbstractTest {
    @Test
    public void testBuilderIsImmutable() {
        MustacheEngineBuilder builder = MustacheEngineBuilder.newBuilder();
        builder.build();
        try {
            builder.addGlobalData("foo", (Object)10);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            builder.addMustacheListener((MustacheListener)new AbstractMustacheListener(){});
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            builder.addResolver((Resolver)new DateTimeFormatResolver());
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            builder.addTemplateLocator((TemplateLocator)new FileSystemTemplateLocator(11, "foo"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            builder.setLocaleSupport(new LocaleSupport(){

                public void init(Configuration configuration) {
                }

                public Set<ConfigurationKey> getConfigurationKeys() {
                    return null;
                }

                public Locale getCurrentLocale() {
                    return null;
                }
            });
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            builder.setTextSupport(new TextSupport(){

                public void init(Configuration configuration) {
                }

                public Set<ConfigurationKey> getConfigurationKeys() {
                    return null;
                }

                public String escapeHtml(String input) {
                    return null;
                }
            });
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            builder.omitServiceLoaderConfigurationExtensions();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            builder.setProperty("foo", (Object)"bar");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            builder.setProperty((ConfigurationKey)EngineConfigurationKey.CACHE_SECTION_LITERAL_BLOCK, (Object)"bar");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            builder.registerCallback(new MustacheEngineBuilder.EngineBuiltCallback(){

                public void engineBuilt(MustacheEngine engine) {
                }
            });
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

