/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.cache.ComputingCache;

public class ComputingCacheTest
extends AbstractEngineTest {
    protected static final Logger logger = LoggerFactory.getLogger(ComputingCacheTest.class);

    @Test
    public void testConcurrentAccess() throws InterruptedException {
        long actions = 10000L;
        int threads = 20;
        Result result = this.runComputations(threads, actions, "my", null, null);
        Assert.assertEquals((long)actions, (long)result.getComputations().get());
        Assert.assertEquals((long)actions, (long)result.getCache().getAllPresent().size());
    }

    protected Result runComputations(int threads, final long actions, String consumerId, Long expirationTimeout, Long maxSize) throws InterruptedException {
        final CountDownLatch startSignal = new CountDownLatch(threads);
        final AtomicLong computations = new AtomicLong();
        final ComputingCache cache = this.engine.getConfiguration().getComputingCacheFactory().create(consumerId, (ComputingCache.Function)new ComputingCache.Function<Long, String>(){

            public String compute(Long key) {
                computations.incrementAndGet();
                return key + ":" + Thread.currentThread().getId();
            }
        }, expirationTimeout, maxSize, null);
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        ArrayList<2> tasks = new ArrayList<2>();
        for (int i = 0; i < threads; ++i) {
            tasks.add(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    startSignal.countDown();
                    startSignal.await();
                    for (long j = 0L; j < actions; ++j) {
                        cache.get((Object)j);
                    }
                    return true;
                }
            });
        }
        List<Future<Boolean>> results = executorService.invokeAll(tasks);
        while (!this.isFinished(results)) {
            Thread.sleep(10L);
        }
        return new Result((ComputingCache<Long, String>)cache, computations);
    }

    private boolean isFinished(List<Future<Boolean>> results) {
        for (Future<Boolean> future : results) {
            if (future.isDone()) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testInvalidate() {
        ComputingCache cache = this.engine.getConfiguration().getComputingCacheFactory().create("test", (ComputingCache.Function)new ComputingCache.Function<Long, String>(){

            public String compute(Long key) {
                return "" + key;
            }
        }, null, null, null);
        for (long i = 0L; i < 100L; ++i) {
            cache.get((Object)i);
        }
        cache.invalidate((ComputingCache.KeyPredicate)new ComputingCache.KeyPredicate<Long>(){

            public boolean apply(Long key) {
                return key % 2L == 0L;
            }
        });
        Assert.assertEquals((long)50L, (long)cache.size());
    }

    @Test
    public void testEviction() throws InterruptedException {
        int threads = 10;
        long actions = 1000L;
        Result result = this.runComputations(threads, actions, "test", null, 500L);
        Assert.assertTrue((result.getComputations().get() >= actions ? 1 : 0) != 0);
        Assert.assertTrue((result.getCache().size() < actions ? 1 : 0) != 0);
    }

    protected static class Result {
        private final ComputingCache<Long, String> cache;
        private final AtomicLong computations;

        public Result(ComputingCache<Long, String> cache, AtomicLong computations) {
            this.cache = cache;
            this.computations = computations;
        }

        public ComputingCache<Long, String> getCache() {
            return this.cache;
        }

        public AtomicLong getComputations() {
            return this.computations;
        }
    }
}

