/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver.i18n;

import com.google.common.collect.ImmutableMap;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.resolver.i18n.DateTimeFormatResolver;

public class DateTimeFormatResolverTest
extends AbstractEngineTest {
    private DateTimeFormatResolver resolver;

    @Override
    @Before
    public void buildEngine() {
        this.resolver = new DateTimeFormatResolver();
        this.engine = MustacheEngineBuilder.newBuilder().setProperty(DateTimeFormatResolver.CUSTOM_PATTERN_KEY, (Object)"DD-MM-yyyy HH:mm").setLocaleSupport(new LocaleSupport(){

            public Locale getCurrentLocale() {
                return Locale.ENGLISH;
            }

            public void init(Configuration configuration) {
            }

            public Set<ConfigurationKey> getConfigurationKeys() {
                return Collections.emptySet();
            }
        }).addResolver((Resolver)this.resolver).build();
    }

    @Test
    public void testResolution() {
        Assert.assertNull((Object)this.resolver.resolve((Object)new Date(), "foo", null));
        Assert.assertNull((Object)this.resolver.resolve((Object)"5", "foo", null));
        Assert.assertNotNull((Object)this.resolver.resolve((Object)5, "format", null));
        Assert.assertNotNull((Object)this.resolver.resolve((Object)Calendar.getInstance(), "formatCustom", null));
        Assert.assertNotNull((Object)this.resolver.resolve((Object)new Date(), "formatDate", null));
    }

    @Test
    public void testInterpolation() {
        Calendar day = Calendar.getInstance();
        day.set(1, 2013);
        day.set(2, 0);
        day.set(5, 1);
        day.set(11, 13);
        day.set(12, 0);
        day.set(13, 0);
        day.set(14, 0);
        long milis = day.getTimeInMillis();
        String expectedShort = "1/1/13 1:00 PM";
        String expectedMedium = "Jan 1, 2013 1:00:00 PM";
        String expectedCustom = "01-01-2013 13:00";
        String expectedDate = "Jan 1, 2013";
        ImmutableMap data = ImmutableMap.of((Object)"calendar", (Object)day, (Object)"date", (Object)day.getTime(), (Object)"milis", (Object)milis);
        Assert.assertEquals((Object)StringUtils.repeat((String)expectedMedium, (String)"|", (int)3), (Object)this.engine.compileMustache("date_time_medium", "{{calendar.format}}|{{date.format}}|{{milis.format}}").render((Object)data));
        Assert.assertEquals((Object)StringUtils.repeat((String)expectedShort, (String)"|", (int)3), (Object)this.engine.compileMustache("date_time_short", "{{calendar.formatShort}}|{{date.formatShort}}|{{milis.formatShort}}").render((Object)data));
        Assert.assertEquals((Object)StringUtils.repeat((String)expectedCustom, (String)"|", (int)3), (Object)this.engine.compileMustache("date_time_custom", "{{calendar.formatCustom}}|{{date.formatCustom}}|{{milis.formatCustom}}").render((Object)data));
        Assert.assertEquals((Object)StringUtils.repeat((String)expectedDate, (String)"|", (int)3), (Object)this.engine.compileMustache("date_only", "{{calendar.formatDate}}|{{date.formatDate}}|{{milis.formatDate}}").render((Object)data));
    }

    @Test(expected=IllegalStateException.class)
    public void testMultipleInit() {
        DateTimeFormatResolver resolver = new DateTimeFormatResolver();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        resolver.init(null);
    }
}

