/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.Hammer;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;

public class ChooseHelperTest
extends AbstractTest {
    @Test
    public void testChooseHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addChoose().build()).build();
        Assert.assertEquals((Object)"transient", (Object)engine.compileMustache("choose_helper1", "{{#choose}}{{#when up.isPersistent}}persistent{{/when}}{{#otherwise}}transient{{/otherwise}}{{/choose}}").render((Object)new Hammer()));
        Assert.assertEquals((Object)"P", (Object)engine.compileMustache("choose_helper2", "{{#choose}}{{#when up}}P{{/when}}{{#otherwise}}T{{/otherwise}}{{/choose}}").render((Object)"not a falsy"));
        Assert.assertEquals((Object)"2", (Object)engine.compileMustache("choose_helper3", "{{#choose}}{{#when up.null}}1{{/when}}{{#when up.age}}2{{/when}}{{#otherwise}}3{{/otherwise}}{{/choose}}").render((Object)new Hammer()));
    }

    @Test
    public void testChooseHelperValidation() {
        final MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addChoose().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("choose_helper_validation01", "{{choose}}");
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("choose_helper_validation02", "{{#choose}}{{when \"true\"}}{{/choose}}");
            }
        }).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("choose_helper_validation03", "{{#choose}}{{#when \"true\"}}{{/when}}{{otherwise \"foo\"}}{{/choose}}");
            }
        });
    }

    @Test
    public void testChooseHelperInvalidFlow() {
        final MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addSet().addChoose().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_OPTIONS).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("choose_helper_invalid_flow01", "{{#choose}}{{#set name=\"bar\"}}{{#when \"foo\"}}{{/when}}{{/set}}{{/choose}}").render((Object)"foo");
            }
        });
    }
}

