/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.AssertUtil;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.handlebars.NumericExpressionHelper;

public class NumberHelpersTest
extends AbstractTest {
    @Test
    public void testIsEven() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addIsEven().build()).build();
        Assert.assertEquals((Object)"even", (Object)engine.compileMustache("isEven_value", "{{#this}}{{isEven iterIndex \"even\"}}{{/this}}").render((Object)new String[]{"1", "2", "3"}));
        Assert.assertEquals((Object)"oddevenodd", (Object)engine.compileMustache("isEven_value_else", "{{#this}}{{isEven iterIndex \"even\" \"odd\"}}{{/this}}").render((Object)new String[]{"1", "2", "3"}));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("isEven_section", "{{#isEven this}}even{{/isEven}}").render((Object)3));
        Assert.assertEquals((Object)"even", (Object)engine.compileMustache("isEven_section", "{{#isEven this}}even{{/isEven}}").render((Object)2));
        AssertUtil.assertCompilationFails(engine, "isEven_fail", "{{isEven}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
    }

    @Test
    public void testIsOdd() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addIsOdd().build()).build();
        Assert.assertEquals((Object)"oddodd", (Object)engine.compileMustache("isOdd_value", "{{#this}}{{isOdd iterIndex \"odd\"}}{{/this}}").render((Object)new String[]{"1", "2", "3"}));
        Assert.assertEquals((Object)"oddevenodd", (Object)engine.compileMustache("isOdd_value", "{{#this}}{{isOdd iterIndex \"odd\" \"even\"}}{{/this}}").render((Object)new String[]{"1", "2", "3"}));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("isOdd_section", "{{#isOdd this}}odd{{/isOdd}}").render((Object)4));
        Assert.assertEquals((Object)"odd", (Object)engine.compileMustache("isOdd_section", "{{#isOdd this}}odd{{/isOdd}}").render((Object)9));
        AssertUtil.assertCompilationFails(engine, "isOdd_fail", "{{isOdd}}", MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE);
    }

    @Test
    public void testNumericExpressionHelper() {
        final MustacheEngine engine = MustacheEngineBuilder.newBuilder().addGlobalData("operator", (Object)"lt").addGlobalData("longValuesSet", (Object)ImmutableSet.of((Object)10L, (Object)12L)).addGlobalData("longValuesArray", (Object)new Long[]{10L, 12L}).registerHelpers(HelpersBuilder.empty().addNumExpr().build()).build();
        ImmutableMap data = ImmutableMap.of((Object)"val1", (Object)2, (Object)"val2", (Object)1, (Object)"val3", (Object)10L, (Object)"val4", (Object)BigDecimal.ZERO, (Object)"val5", (Object)BigInteger.ONE);
        Assert.assertEquals((Object)"true", (Object)engine.compileMustache("number_pos1", "{{numExpr this op='pos'}}").render((Object)1L));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("number_pos2", "{{numExpr this op='pos'}}").render((Object)-1L));
        Assert.assertEquals((Object)"true", (Object)engine.compileMustache("number_pos3", "{{numExpr 10 op='pos'}}").render(null));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("number_neg1", "{{numExpr this op='neg'}}").render((Object)1L));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_neg2", "{{numExpr this op='neg' out='yes'}}").render((Object)-1L));
        Assert.assertEquals((Object)"true", (Object)engine.compileMustache("number_eq1", "{{numExpr this '1'}}").render((Object)1L));
        Assert.assertEquals((Object)"One!", (Object)engine.compileMustache("number_eq2", "{{numExpr this '1' out='One!'}}").render((Object)1L));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_eq3", "{{#numExpr this '1' op='eq'}}yes{{/numExpr}}").render((Object)1L));
        Assert.assertEquals((Object)"Not equal!", (Object)engine.compileMustache("number_neq1", "{{numExpr -2 +2 op='neq' out='Not equal!'}}").render((Object)1L));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_gt1", "{{#numExpr val1 val2 op='gt'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_gt2", "{{#numExpr val1 '0.1' op='gt'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_gt3", "{{#numExpr '0.1' val4 op='gt'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_lt1", "{{#numExpr val2 val1 op='lt'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_ge1", "{{#numExpr val3 '10' op='ge'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("number_ge2", "{{#numExpr val2 val3 op='ge'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_ge3", "{{#numExpr this 5 op='ge'}}yes{{/numExpr}}").render((Object)10));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_le1", "{{#numExpr val2 val3 op='le'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_lt1", "{{#numExpr val1 '2' op='le'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("number_lt2", "{{#numExpr val1 '0' op='le'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("number_in1", "{{#numExpr val1 '0' '5' val3 op='in'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_in2", "{{#numExpr val1 '0' '5' val1 op='in'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_in3", "{{#numExpr 10l longValuesSet op='in'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_nin1", "{{#numExpr val1 '0' '5' op='nin'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("number_nin2", "{{#numExpr '0' '5' '0' op='nin'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_nin3", "{{#numExpr 0 longValuesArray op='nin'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_unknown_op", "{{#numExpr val1 2 op='unknown!'}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_default_op", "{{#numExpr val1 2}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_dynamic_op", "{{#numExpr val1 3 op=operator}}yes{{/numExpr}}").render((Object)data));
        Assert.assertEquals((Object)"yes", (Object)engine.compileMustache("number_biginteger_val", "{{#numExpr val5 val4 op='gt'}}yes{{/numExpr}}").render((Object)data));
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_OPTIONS).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("number_invalid_val", "{{#numExpr this op='neg'}}yes{{/numExpr}}").render(new ArrayList());
            }
        });
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("number_invalid_params", "{{#numExpr this op='eq'}}yes{{/numExpr}}");
            }
        });
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_OPTIONS).check(new Runnable(){

            @Override
            public void run() {
                engine.compileMustache("number_invalid_val", "{{#numExpr this op=operator}}yes{{/numExpr}}").render(new ArrayList());
            }
        });
    }

    @Test
    public void testNumericExpressionHelperDefaultOperator() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("gt", (Helper)new NumericExpressionHelper(NumericExpressionHelper.Operator.GT)).build();
        Assert.assertEquals((Object)"foo", (Object)engine.compileMustache("number_default_op", "{{#gt this 10}}foo{{/gt}}").render((Object)11L));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("number_default_op", "{{#gt this 10}}foo{{/gt}}").render((Object)10L));
    }
}

