/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.spec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.spec.Definition;
import org.trimou.spec.Lambdas;

public final class SpecUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpecUtils.class);

    static void executeTests(String filename, String specVersion) throws IOException {
        SpecUtils.executeTests(filename, specVersion, null);
    }

    static void executeTests(String filename, String specVersion, String singleTest) throws IOException {
        List<Definition> definitions = SpecUtils.parseDefinitions(SpecUtils.getSpecFile(filename, specVersion));
        if (!definitions.isEmpty()) {
            int idx = 0;
            int failures = 0;
            for (Definition definition : definitions) {
                if (singleTest != null && !singleTest.equals(definition.getName())) continue;
                MapTemplateLocator mockTemplateLocator = new MapTemplateLocator(definition.getPartials());
                MustacheEngine factory = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)mockTemplateLocator).setProperty((ConfigurationKey)EngineConfigurationKey.HANDLEBARS_SUPPORT_ENABLED, (Object)false).build();
                ++idx;
                try {
                    Assert.assertEquals((Object)definition.getExpected(), (Object)factory.compileMustache(definition.getName(), definition.getTemplate()).render(definition.getData()));
                }
                catch (Exception e) {
                    ++failures;
                    logger.error("{} {}: {} - {}", new Object[]{idx, definition.getName(), e.getClass(), e.getMessage()});
                }
                catch (Error e) {
                    ++failures;
                    logger.error("{} {}: {} - {}", new Object[]{idx, definition.getName(), e.getClass(), e.getMessage()});
                }
            }
            logger.warn("Spec tests finished [filename: {}, tests: {}, failures: {}]", new Object[]{filename, definitions.size(), failures});
            if (failures > 0) {
                Assert.fail((String)String.format("Spec tests failures: %s", failures));
            }
        }
    }

    static Reader getSpecFile(String filename, String specVersion) {
        return new InputStreamReader(SpecUtils.class.getResourceAsStream("/spec/" + specVersion + "/" + filename));
    }

    static List<Definition> parseDefinitions(Reader reader) throws IOException {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        JsonParser parser = new JsonParser();
        JsonElement spec = parser.parse(reader);
        reader.close();
        JsonArray tests = spec.getAsJsonObject().get("tests").getAsJsonArray();
        for (JsonElement test : tests) {
            JsonObject testObject = test.getAsJsonObject();
            Definition definition = new Definition();
            definition.setName(testObject.get("name").getAsString());
            definition.setDesc(testObject.get("desc").getAsString());
            definition.setTemplate(testObject.get("template").getAsString());
            definition.setExpected(testObject.get("expected").getAsString());
            HashMap<String, Object> data = new HashMap<String, Object>();
            JsonObject dataObject = testObject.get("data").getAsJsonObject();
            for (Map.Entry property : dataObject.entrySet()) {
                if (((String)property.getKey()).equals("lambda")) continue;
                data.put((String)property.getKey(), SpecUtils.getJsonElementValue((JsonElement)property.getValue()));
            }
            if (Lambdas.testMap.containsKey(definition.getName())) {
                data.put("lambda", Lambdas.testMap.get(definition.getName()));
            }
            definition.setData(data);
            if (testObject.has("partials")) {
                JsonObject partialsObject = testObject.get("partials").getAsJsonObject();
                HashMap<String, String> partials = new HashMap<String, String>();
                for (Map.Entry entry : partialsObject.entrySet()) {
                    partials.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                definition.setPartials(partials);
            }
            definitions.add(definition);
        }
        return definitions;
    }

    private static Object getJsonElementValue(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return SpecUtils.getJsonPrimitiveElementValue(element);
        }
        if (element.isJsonArray()) {
            return SpecUtils.getJsonArrayElementValue(element);
        }
        if (element.isJsonObject()) {
            HashMap objectData = new HashMap();
            for (Map.Entry objectProperty : element.getAsJsonObject().entrySet()) {
                objectData.put(objectProperty.getKey(), SpecUtils.getJsonElementValue((JsonElement)objectProperty.getValue()));
            }
            return objectData;
        }
        if (element.isJsonNull()) {
            return null;
        }
        throw new IllegalStateException("Unsupported JSON element");
    }

    private static Object getJsonPrimitiveElementValue(JsonElement element) {
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        if (primitive.isNumber()) {
            return primitive.getAsNumber();
        }
        throw new IllegalStateException("Unsupported primitive type");
    }

    private static Object getJsonArrayElementValue(JsonElement element) {
        JsonArray array = element.getAsJsonArray();
        ArrayList<Object> values = new ArrayList<Object>(array.size());
        for (JsonElement jsonElement : array) {
            values.add(SpecUtils.getJsonElementValue(jsonElement));
        }
        return values;
    }
}

