/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.util.Patterns;

public class PatternsTest {
    @Test
    public void testMustacheTagPattern() {
        String text = "{{foo }} and {{#bar}}...{{/bar}}";
        Pattern tagPattern = Patterns.newMustacheTagPattern((Configuration)MustacheEngineBuilder.newBuilder().build().getConfiguration());
        Matcher matcher = tagPattern.matcher(text);
        StringBuffer result = new StringBuffer();
        int occurences = 0;
        while (matcher.find()) {
            System.out.println(matcher.group(0));
            matcher.appendReplacement(result, "FOUND");
            ++occurences;
        }
        matcher.appendTail(result);
        Assert.assertEquals((long)3L, (long)occurences);
        Assert.assertEquals((Object)"FOUND and FOUND...FOUND", (Object)result.toString());
    }

    @Test
    public void testSetDelimitersPattern() {
        String set1 = "<% %>";
        String set2 = "[ ]";
        String set3 = "= =";
        Pattern setDelimitersPattern = Patterns.newSetDelimitersContentPattern();
        Matcher set1Matcher = setDelimitersPattern.matcher(set1);
        Assert.assertEquals((Object)true, (Object)set1Matcher.find());
        Assert.assertEquals((Object)"<%", (Object)set1Matcher.group(1));
        Assert.assertEquals((Object)"%>", (Object)set1Matcher.group(3));
        Matcher set2Matcher = setDelimitersPattern.matcher(set2);
        Assert.assertEquals((Object)true, (Object)set2Matcher.find());
        Assert.assertEquals((Object)"[", (Object)set2Matcher.group(1));
        Assert.assertEquals((Object)"]", (Object)set2Matcher.group(3));
        Matcher set3Matcher = setDelimitersPattern.matcher(set3);
        Assert.assertEquals((Object)true, (Object)set3Matcher.find());
        Assert.assertEquals((Object)"=", (Object)set3Matcher.group(1));
        Assert.assertEquals((Object)"=", (Object)set3Matcher.group(3));
    }

    @Test
    public void testHelperNameValidationPattern() {
        Pattern pattern = Patterns.newHelperNameValidationPattern();
        Assert.assertTrue((boolean)pattern.matcher("name param1 param2 hash1=\"value1\" hash2=value2").matches());
        Assert.assertTrue((boolean)pattern.matcher("name").matches());
        Assert.assertTrue((boolean)pattern.matcher("name param1.dot.lookup").matches());
        Assert.assertTrue((boolean)pattern.matcher("name hash1=\"value1\"").matches());
        Assert.assertTrue((boolean)pattern.matcher("name.-1").matches());
        Assert.assertTrue((boolean)pattern.matcher("\"foo/bar/path\"").matches());
        Assert.assertTrue((boolean)pattern.matcher("ke\u010dup").matches());
        Assert.assertTrue((boolean)pattern.matcher("foo[\"bar\"]").matches());
        Assert.assertTrue((boolean)pattern.matcher("name  \"param1\" \"param2\" hash1=\"foo bar\" hash2=value2.foo").matches());
        Assert.assertTrue((boolean)pattern.matcher("name  hash1=\"DD-MM-yyyy HH:mm\"").matches());
        Assert.assertTrue((boolean)pattern.matcher("name  hash1=\"<html>\"").matches());
        Assert.assertTrue((boolean)pattern.matcher("name key='value'").matches());
    }

    @Test
    public void testHelperStringLiteralPattern() {
        Assert.assertTrue((boolean)Patterns.newHelperStringLiteralPattern().matcher("\"foo\"").matches());
        Assert.assertTrue((boolean)Patterns.newHelperStringLiteralPattern().matcher("\"DD-MM-yyyy HH:mm\"").matches());
        Assert.assertFalse((boolean)Patterns.newHelperStringLiteralPattern().matcher("\"foo").matches());
    }

    @Test
    public void testHelperIntOrLongLiteralPattern() {
        Assert.assertFalse((boolean)Patterns.newHelperIntegerLiteralPattern().matcher("\"foo\"").matches());
        Assert.assertTrue((boolean)Patterns.newHelperIntegerLiteralPattern().matcher("1").matches());
        Assert.assertTrue((boolean)Patterns.newHelperIntegerLiteralPattern().matcher("+12").matches());
        Assert.assertTrue((boolean)Patterns.newHelperIntegerLiteralPattern().matcher("-10000").matches());
        Assert.assertFalse((boolean)Patterns.newHelperIntegerLiteralPattern().matcher("1.0").matches());
        Assert.assertFalse((boolean)Patterns.newHelperIntegerLiteralPattern().matcher("1000000000000").matches());
    }
}

