/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.interpolation;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.interpolation.LiteralSupport;
import org.trimou.util.Patterns;
import org.trimou.util.Strings;

public class DefaultLiteralSupport
extends AbstractConfigurationAware
implements LiteralSupport {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLiteralSupport.class);
    private final Pattern integerLiteralPattern = Patterns.newHelperIntegerLiteralPattern();
    private final Pattern longLiteralPattern = Patterns.newHelperLongLiteralPattern();

    @Override
    public Object getLiteral(String value, MustacheTagInfo tagInfo) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        Object literal = null;
        if (Strings.isStringLiteralSeparator(value.charAt(0))) {
            literal = value.substring(1, value.length() - 1);
        } else if (this.integerLiteralPattern.matcher(value).matches()) {
            try {
                literal = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                logger.warn("Unable to parse integer literal: " + value, (Throwable)e);
            }
        } else if (this.longLiteralPattern.matcher(value).matches()) {
            try {
                literal = Long.parseLong(value.substring(0, value.length() - 1));
            }
            catch (NumberFormatException e) {
                logger.warn("Unable to parse long literal: " + value, (Throwable)e);
            }
        }
        return literal;
    }
}

