/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.trimou.annotations.Internal;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.AbstractSectionSegment;
import org.trimou.engine.segment.Origin;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.Segments;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

@Internal
public class ExtendSegment
extends AbstractSectionSegment {
    private final AtomicReference<Template> cachedExtendedTemplate = Segments.isTemplateCachingAllowed(this.getEngineConfiguration()) ? new AtomicReference() : null;

    public ExtendSegment(String text, Origin origin, List<Segment> segments) {
        super(text, origin, segments);
    }

    @Override
    public SegmentType getType() {
        return SegmentType.EXTEND;
    }

    @Override
    public Appendable execute(Appendable appendable, ExecutionContext context) {
        Template extended = Segments.getTemplate(this.cachedExtendedTemplate, this.getText(), this.getEngine());
        if (extended == null) {
            throw new MustacheException(MustacheProblem.RENDER_INVALID_EXTEND_KEY, "No template to extend found for the given key: %s %s", this.getText(), this.getOrigin());
        }
        return extended.getRootSegment().execute(appendable, context.setDefiningSections(this));
    }
}

