/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.interpolation;

import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.Hammer;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.interpolation.BracketDotKeySplitter;
import org.trimou.engine.interpolation.KeySplitter;

public class BracketDotKeySplitterTest {
    @Test
    public void testSplit() {
        BracketDotKeySplitter splitter = new BracketDotKeySplitter();
        this.assertIterator(splitter.split("a..bar:.c"), "a", "bar:", "c");
        this.assertIterator(splitter.split(". "), " ");
        this.assertIterator(splitter.split("."), ".");
        this.assertIterator(splitter.split("foo"), "foo");
        this.assertIterator(splitter.split("foo[\"bar\"]"), "foo", "bar");
        this.assertIterator(splitter.split("foo[\"a.b.c\"]"), "foo", "a.b.c");
        this.assertIterator(splitter.split("foo[\"bar\"].baz"), "foo", "bar", "baz");
        this.assertIterator(splitter.split("a[\"b\"].c.d[\"e\"][\"f\"]"), "a", "b", "c", "d", "e", "f");
        this.assertIterator(splitter.split("foo['bar']"), "foo", "bar");
        this.assertIterator(splitter.split("foo['bar dot'][\"qux\"].me"), "foo", "bar dot", "qux", "me");
    }

    @Test
    public void testInterpolation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setKeySplitter((KeySplitter)new BracketDotKeySplitter()).build();
        Assert.assertEquals((Object)"10", (Object)engine.compileMustache("bracket_dot_key_splitter_01", "{{this[\"age\"]}}").render((Object)new Hammer()));
        Assert.assertEquals((Object)"foo", (Object)engine.compileMustache("bracket_dot_key_splitter_02", "{{this[0]}}").render((Object)new String[]{"foo"}));
    }

    private void assertIterator(Iterator<String> iterator, Object ... elements) {
        int idx = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)elements[idx], (Object)iterator.next());
            ++idx;
        }
        if (idx != elements.length) {
            Assert.fail((String)"Incorrect number of elements");
        }
    }
}

