/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.ExtendSectionSegment;
import org.trimou.engine.segment.ExtendSegment;
import org.trimou.engine.segment.InvertedSectionSegment;
import org.trimou.engine.segment.SectionSegment;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;

public class ParsingTest
extends AbstractEngineTest {
    @Test
    public void testVariable() {
        Template template = (Template)this.engine.compileMustache("parse_variable", "Hello {{foo}} and {{& me}}!");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)5L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.TEXT, "Hello ");
        ParsingTest.validateSegment(segments, 1, SegmentType.VALUE, "foo");
        ParsingTest.validateSegment(segments, 2, SegmentType.TEXT, " and ");
        ParsingTest.validateSegment(segments, 3, SegmentType.VALUE, "me");
        ParsingTest.validateSegment(segments, 4, SegmentType.TEXT, "!");
    }

    @Test
    public void testComment() {
        Template template = (Template)this.engine.compileMustache("parse_comment", "{{! ignore}}{{me}}");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.VALUE, "me");
    }

    @Test
    public void testSection() {
        Template template = (Template)this.engine.compileMustache("parse_section", "This is a {{#section}} jupi {{mustache}} {{/section}}");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)2L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.TEXT, "This is a ");
        ParsingTest.validateSegment(segments, 1, SegmentType.SECTION, "section");
        Assert.assertEquals((long)3L, (long)((SectionSegment)segments.get(1)).getSegments().size());
    }

    @Test
    public void testInvertedSection() {
        Template template = (Template)this.engine.compileMustache("parse_inv_section", "This is a {{^section}} jupi {{/section}}");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)2L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.TEXT, "This is a ");
        ParsingTest.validateSegment(segments, 1, SegmentType.INVERTED_SECTION, "section");
        Assert.assertEquals((long)1L, (long)((InvertedSectionSegment)segments.get(1)).getSegments().size());
    }

    @Test
    public void testDelimiters() {
        Template template = (Template)this.engine.compileMustache("parse_delimiters", "This {{=%% %%=}} is a %%foo%% jupi %%={{ }}=%% {{bar}}");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)6L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.TEXT, "This ");
        ParsingTest.validateSegment(segments, 1, SegmentType.TEXT, " is a ");
        ParsingTest.validateSegment(segments, 2, SegmentType.VALUE, "foo");
        ParsingTest.validateSegment(segments, 3, SegmentType.TEXT, " jupi ");
        ParsingTest.validateSegment(segments, 4, SegmentType.TEXT, " ");
        ParsingTest.validateSegment(segments, 5, SegmentType.VALUE, "bar");
    }

    @Test
    public void testPartials() {
        Template template = (Template)this.engine.compileMustache("parse_partial", "START{{>partial}}END");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)3L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.TEXT, "START");
        ParsingTest.validateSegment(segments, 1, SegmentType.PARTIAL, "partial");
        ParsingTest.validateSegment(segments, 2, SegmentType.TEXT, "END");
    }

    @Test
    public void testLineSeparator() {
        Template template = (Template)this.engine.compileMustache("parse_line_sep_01", "\nHello {{foo}}\r\n\n and {{& me}}!\nAND\r\r");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)12L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.LINE_SEPARATOR, "\n");
        ParsingTest.validateSegment(segments, 1, SegmentType.TEXT, "Hello ");
        ParsingTest.validateSegment(segments, 2, SegmentType.VALUE, "foo");
        ParsingTest.validateSegment(segments, 3, SegmentType.LINE_SEPARATOR, "\r\n");
        ParsingTest.validateSegment(segments, 4, SegmentType.LINE_SEPARATOR, "\n");
        ParsingTest.validateSegment(segments, 5, SegmentType.TEXT, " and ");
        ParsingTest.validateSegment(segments, 6, SegmentType.VALUE, "me");
        ParsingTest.validateSegment(segments, 7, SegmentType.TEXT, "!");
        ParsingTest.validateSegment(segments, 8, SegmentType.LINE_SEPARATOR, "\n");
        ParsingTest.validateSegment(segments, 9, SegmentType.TEXT, "AND");
        ParsingTest.validateSegment(segments, 10, SegmentType.LINE_SEPARATOR, "\r");
        ParsingTest.validateSegment(segments, 11, SegmentType.LINE_SEPARATOR, "\r");
        template = (Template)this.engine.compileMustache("parse_line_sep_02", "\n\n ");
        segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)3L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.LINE_SEPARATOR, "\n");
        ParsingTest.validateSegment(segments, 1, SegmentType.LINE_SEPARATOR, "\n");
        ParsingTest.validateSegment(segments, 2, SegmentType.TEXT, " ");
        template = (Template)this.engine.compileMustache("parse_line_sep_03", "\r\n\r\n\r\r\n\n \n\r ");
        segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)9L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.LINE_SEPARATOR, "\r\n");
        ParsingTest.validateSegment(segments, 1, SegmentType.LINE_SEPARATOR, "\r\n");
        ParsingTest.validateSegment(segments, 2, SegmentType.LINE_SEPARATOR, "\r");
        ParsingTest.validateSegment(segments, 3, SegmentType.LINE_SEPARATOR, "\r\n");
        ParsingTest.validateSegment(segments, 4, SegmentType.LINE_SEPARATOR, "\n");
        ParsingTest.validateSegment(segments, 5, SegmentType.TEXT, " ");
        ParsingTest.validateSegment(segments, 6, SegmentType.LINE_SEPARATOR, "\n");
        ParsingTest.validateSegment(segments, 7, SegmentType.LINE_SEPARATOR, "\r");
        ParsingTest.validateSegment(segments, 8, SegmentType.TEXT, " ");
    }

    @Test
    public void testStandaloneLines() {
        Template template = (Template)this.engine.compileMustache("parse_standalone_line", "\nHello {{foo}}\n{{! Standalone}}\n and {{& me}}!\n{{#test}}\nyes\n{{/test}}");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)9L, (long)segments.size());
        Assert.assertEquals((Object)SegmentType.LINE_SEPARATOR, (Object)((Segment)segments.get(0)).getType());
        Assert.assertEquals((Object)SegmentType.TEXT, (Object)((Segment)segments.get(1)).getType());
        Assert.assertEquals((Object)SegmentType.VALUE, (Object)((Segment)segments.get(2)).getType());
        Assert.assertEquals((Object)SegmentType.LINE_SEPARATOR, (Object)((Segment)segments.get(3)).getType());
        Assert.assertEquals((Object)SegmentType.TEXT, (Object)((Segment)segments.get(4)).getType());
        Assert.assertEquals((Object)SegmentType.VALUE, (Object)((Segment)segments.get(5)).getType());
        Assert.assertEquals((Object)SegmentType.TEXT, (Object)((Segment)segments.get(6)).getType());
        Assert.assertEquals((Object)SegmentType.LINE_SEPARATOR, (Object)((Segment)segments.get(7)).getType());
        Assert.assertEquals((Object)SegmentType.SECTION, (Object)((Segment)segments.get(8)).getType());
    }

    @Test
    public void testExtendSegments() {
        Template template = (Template)this.engine.compileMustache("parse_extend_super", "Hello {{$insert}}default content{{/insert}}!");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)3L, (long)segments.size());
        Assert.assertEquals((Object)SegmentType.TEXT, (Object)((Segment)segments.get(0)).getType());
        Assert.assertEquals((Object)SegmentType.EXTEND_SECTION, (Object)((Segment)segments.get(1)).getType());
        Assert.assertEquals((Object)SegmentType.TEXT, (Object)((Segment)segments.get(2)).getType());
        segments = ((ExtendSectionSegment)segments.get(1)).getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)SegmentType.TEXT, (Object)((Segment)segments.get(0)).getType());
        template = (Template)this.engine.compileMustache("parse_extend_sub", "Intro... {{<super}} skip {{$insert}}default content{{/insert}} skip! {{/super}} ...outro");
        segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)3L, (long)segments.size());
        Assert.assertEquals((Object)SegmentType.TEXT, (Object)((Segment)segments.get(0)).getType());
        Assert.assertEquals((Object)SegmentType.EXTEND, (Object)((Segment)segments.get(1)).getType());
        Assert.assertEquals((Object)SegmentType.TEXT, (Object)((Segment)segments.get(2)).getType());
        segments = ((ExtendSegment)segments.get(1)).getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((Object)SegmentType.EXTEND_SECTION, (Object)((Segment)segments.get(0)).getType());
    }

    @Test
    public void testAccentedLetters() {
        String text1 = "Te\u010f testujeme";
        String var1 = "akcentovan\u00e9";
        String var2 = "\u011b\u0161\u010d\u011b\u0161\u0159\u00e9\u00e1\u00ed\u00e9\u00ed\u0159\u010d\u017e\u010d";
        Template template = (Template)this.engine.compileMustache("parse_accented_letters", text1 + "{{" + var1 + "}}{{& " + var2 + "}}");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)3L, (long)segments.size());
        Assert.assertEquals((Object)SegmentType.TEXT, (Object)((Segment)segments.get(0)).getType());
        Assert.assertEquals((Object)text1, (Object)((Segment)segments.get(0)).getText());
        Assert.assertEquals((Object)SegmentType.VALUE, (Object)((Segment)segments.get(1)).getType());
        Assert.assertEquals((Object)var1, (Object)((Segment)segments.get(1)).getText());
        Assert.assertEquals((Object)SegmentType.VALUE, (Object)((Segment)segments.get(2)).getType());
        Assert.assertEquals((Object)var2, (Object)((Segment)segments.get(2)).getText());
    }

    @Test
    public void testLineSeparatorAfterIncompleteDelimiter() {
        Template template = (Template)this.engine.compileMustache("parse_line_sep_incomplete_delim", "{\nHello!");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)3L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.TEXT, "{");
        ParsingTest.validateSegment(segments, 1, SegmentType.LINE_SEPARATOR, "\n");
        ParsingTest.validateSegment(segments, 2, SegmentType.TEXT, "Hello!");
    }

    static void validateSegment(List<Segment> segments, int index, SegmentType expectedType, String expectedText) {
        Segment segment = segments.get(index);
        Assert.assertEquals((Object)expectedType, (Object)segment.getType());
        Assert.assertEquals((Object)expectedText, (Object)segment.getText());
    }
}

