/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.resolver.DummyTransformResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.resolver.Transformer;

public class DummyTransformResolverTest
extends AbstractTest {
    final DummyTransformResolver resolver = new DummyTransformResolver(100, new Transformer(){

        public Object transform(Object contextObject, String name, ResolutionContext context) {
            return "{{" + name.toUpperCase() + "}}";
        }
    }, new String[]{"ng"});

    @Test
    public void testResolution() {
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)this.resolver).build();
        Assert.assertNull((Object)this.resolver.resolve(null, "whatever", null));
        Object marker = this.resolver.resolve(null, "ng", null);
        Assert.assertNotNull((Object)marker);
        Assert.assertEquals((Object)"{{FOO}}", (Object)this.resolver.resolve(marker, "foo", null));
    }

    @Test
    public void testInterpolation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addResolver((Resolver)this.resolver).build();
        Assert.assertEquals((Object)"{{FOO}}", (Object)engine.compileMustache("dummy_transform_resolver", "{{ng.foo}}").render(null));
    }
}

