/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver.i18n;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.resolver.i18n.NumberFormatResolver;

public class NumberFormatResolverTest
extends AbstractEngineTest {
    private NumberFormatResolver resolver;

    @Override
    @Before
    public void buildEngine() {
        this.resolver = new NumberFormatResolver();
        this.engine = MustacheEngineBuilder.newBuilder().setLocaleSupport(new LocaleSupport(){

            public Locale getCurrentLocale() {
                return new Locale("cs", "CZ");
            }

            public void init(Configuration configuration) {
            }

            public Set<ConfigurationKey> getConfigurationKeys() {
                return Collections.emptySet();
            }
        }).addResolver((Resolver)this.resolver).build();
    }

    @Test
    public void testResolution() {
        Assert.assertNull((Object)this.resolver.resolve((Object)new Date(), "foo", null));
        Assert.assertNull((Object)this.resolver.resolve((Object)5, "foo", null));
        Assert.assertNotNull((Object)this.resolver.resolve((Object)5, "format", null));
    }

    @Test
    public void testInterpolation() {
        String templateContents = "{{number.format}}|{{number.formatPercent}}|{{number.formatCurrency}}";
        Mustache mustache = this.engine.compileMustache("number", templateContents);
        Assert.assertEquals((Object)"1,5|150%|1,5 K\u010d", (Object)mustache.render((Object)ImmutableMap.of((Object)"number", (Object)new BigDecimal("1.5"))));
    }

    @Test(expected=IllegalStateException.class)
    public void testMultipleInit() {
        NumberFormatResolver resolver = new NumberFormatResolver();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        resolver.init(null);
    }
}

