/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.interpolation;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.interpolation.KeySplitter;
import org.trimou.util.Strings;

public class BracketDotKeySplitter
extends AbstractConfigurationAware
implements KeySplitter {
    @Override
    public Iterator<String> split(String key) {
        if (key.equals(".")) {
            return Iterators.singletonIterator((Object)".");
        }
        if (key.equals("this")) {
            return Iterators.singletonIterator((Object)"this");
        }
        boolean stringLiteral = false;
        boolean separator = false;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            if (this.isSeparator(key.charAt(i))) {
                if (separator) continue;
                if (!stringLiteral) {
                    if (buffer.length() > 0) {
                        parts.add(buffer.toString());
                        buffer = new StringBuilder();
                    }
                    separator = true;
                    continue;
                }
                buffer.append(key.charAt(i));
                continue;
            }
            if (Strings.isStringLiteralSeparator(key.charAt(i))) {
                stringLiteral = !stringLiteral;
            } else {
                buffer.append(key.charAt(i));
            }
            separator = false;
        }
        if (buffer.length() > 0) {
            parts.add(buffer.toString());
        }
        return parts.iterator();
    }

    private boolean isSeparator(char candidate) {
        return candidate == '.' || candidate == '[' || candidate == ']';
    }
}

