/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.locator.AbstractTemplateLocator;

public abstract class PathTemplateLocator<T>
extends AbstractTemplateLocator {
    private static final Logger logger = LoggerFactory.getLogger(PathTemplateLocator.class);
    public static final ConfigurationKey VIRTUAL_PATH_SEPARATOR_KEY = new SimpleConfigurationKey(PathTemplateLocator.class.getName() + ".virtualPathSeparator", "/");
    private final String suffix;
    private final String rootPath;
    private String virtualPathSeparator;
    private String defaultFileEncoding;

    public PathTemplateLocator(int priority, String rootPath) {
        this(priority, rootPath, null);
    }

    public PathTemplateLocator(int priority, String rootPath, String suffix) {
        super(priority);
        this.suffix = suffix;
        this.rootPath = this.initRootPath(rootPath);
    }

    @Override
    public void init() {
        this.virtualPathSeparator = this.configuration.getStringPropertyValue(VIRTUAL_PATH_SEPARATOR_KEY);
        this.defaultFileEncoding = this.configuration.getStringPropertyValue(EngineConfigurationKey.DEFAULT_FILE_ENCODING);
        logger.info("{} initialized [virtualPathSeparator: {}, defaultFileEncoding: {}]", new Object[]{this.getClass().getSimpleName(), this.getVirtualPathSeparator(), this.getDefaultFileEncoding()});
    }

    @Override
    public Set<ConfigurationKey> getConfigurationKeys() {
        return Collections.singleton(VIRTUAL_PATH_SEPARATOR_KEY);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    protected String stripSuffix(String filename) {
        return this.suffix != null ? StringUtils.removeEnd((String)filename, (String)("." + this.suffix)) : filename;
    }

    protected String addSuffix(String filename) {
        return this.suffix != null ? filename + "." + this.suffix : filename;
    }

    protected String getRealPathSeparator() {
        return "/";
    }

    protected String getVirtualPathSeparator() {
        return this.virtualPathSeparator;
    }

    protected String getDefaultFileEncoding() {
        return this.defaultFileEncoding;
    }

    protected abstract String constructVirtualPath(T var1);

    protected String toRealPath(String virtualPath) {
        String[] parts = StringUtils.split((String)virtualPath, (String)this.getVirtualPathSeparator());
        StringBuilder realPath = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            realPath.append(parts[i]);
            if (i + 1 >= parts.length) continue;
            realPath.append(this.getRealPathSeparator());
        }
        return realPath.toString();
    }

    private String initRootPath(String rootPath) {
        if (StringUtils.isEmpty((CharSequence)rootPath)) {
            return null;
        }
        return rootPath.endsWith(this.getRealPathSeparator()) ? rootPath : rootPath + this.getRealPathSeparator();
    }

    public String toString() {
        return String.format("%s [priority: %s, suffix: %s, rootPath: %s]", this.getClass().getName(), this.getPriority(), this.getSuffix(), this.getRootPath());
    }
}

